package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.state;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BridgeDomainBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BridgeDomainBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new BridgeDomainBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BridgeDomainBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BridgeDomainBuilder
 * @see Builder
 *
 */
public class BridgeDomainBuilder implements Builder<BridgeDomain> {

    private ArpTerminationTable _arpTerminationTable;
    private L2FibTable _l2FibTable;
    private String _name;
    private Boolean _arpTermination;
    private Boolean _flood;
    private Boolean _forward;
    private Boolean _learn;
    private Boolean _unknownUnicastFlood;
    private BridgeDomainKey key;


    Map<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> augmentation = Collections.emptyMap();

    public BridgeDomainBuilder() {
    }
    public BridgeDomainBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes arg) {
        this._flood = arg.isFlood();
        this._forward = arg.isForward();
        this._learn = arg.isLearn();
        this._unknownUnicastFlood = arg.isUnknownUnicastFlood();
        this._arpTermination = arg.isArpTermination();
        this._arpTerminationTable = arg.getArpTerminationTable();
    }
    public BridgeDomainBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes arg) {
        this._l2FibTable = arg.getL2FibTable();
    }

    public BridgeDomainBuilder(BridgeDomain base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> aug =((AugmentationHolder<BridgeDomain>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._name = base.getName();
        this._arpTerminationTable = base.getArpTerminationTable();
        this._l2FibTable = base.getL2FibTable();
        this._arpTermination = base.isArpTermination();
        this._flood = base.isFlood();
        this._forward = base.isForward();
        this._learn = base.isLearn();
        this._unknownUnicastFlood = base.isUnknownUnicastFlood();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes) {
            this._flood = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isFlood();
            this._forward = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isForward();
            this._learn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isLearn();
            this._unknownUnicastFlood = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isUnknownUnicastFlood();
            this._arpTermination = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isArpTermination();
            this._arpTerminationTable = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).getArpTerminationTable();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes) {
            this._l2FibTable = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes)arg).getL2FibTable();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes]");
    }

    public BridgeDomainKey key() {
        return key;
    }
    
    public ArpTerminationTable getArpTerminationTable() {
        return _arpTerminationTable;
    }
    
    public L2FibTable getL2FibTable() {
        return _l2FibTable;
    }
    
    public String getName() {
        return _name;
    }
    
    public Boolean isArpTermination() {
        return _arpTermination;
    }
    
    public Boolean isFlood() {
        return _flood;
    }
    
    public Boolean isForward() {
        return _forward;
    }
    
    public Boolean isLearn() {
        return _learn;
    }
    
    public Boolean isUnknownUnicastFlood() {
        return _unknownUnicastFlood;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BridgeDomain>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public BridgeDomainBuilder withKey(final BridgeDomainKey key) {
        this.key = key;
        return this;
    }
    
    public BridgeDomainBuilder setArpTerminationTable(final ArpTerminationTable value) {
        this._arpTerminationTable = value;
        return this;
    }
    
    public BridgeDomainBuilder setL2FibTable(final L2FibTable value) {
        this._l2FibTable = value;
        return this;
    }
    
    public BridgeDomainBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    public BridgeDomainBuilder setArpTermination(final Boolean value) {
        this._arpTermination = value;
        return this;
    }
    
    public BridgeDomainBuilder setFlood(final Boolean value) {
        this._flood = value;
        return this;
    }
    
    public BridgeDomainBuilder setForward(final Boolean value) {
        this._forward = value;
        return this;
    }
    
    public BridgeDomainBuilder setLearn(final Boolean value) {
        this._learn = value;
        return this;
    }
    
    public BridgeDomainBuilder setUnknownUnicastFlood(final Boolean value) {
        this._unknownUnicastFlood = value;
        return this;
    }
    
    public BridgeDomainBuilder addAugmentation(Class<? extends Augmentation<BridgeDomain>> augmentationType, Augmentation<BridgeDomain> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BridgeDomainBuilder removeAugmentation(Class<? extends Augmentation<BridgeDomain>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BridgeDomain build() {
        return new BridgeDomainImpl(this);
    }

    private static final class BridgeDomainImpl
        extends AbstractAugmentable<BridgeDomain>
        implements BridgeDomain {
    
        private final ArpTerminationTable _arpTerminationTable;
        private final L2FibTable _l2FibTable;
        private final String _name;
        private final Boolean _arpTermination;
        private final Boolean _flood;
        private final Boolean _forward;
        private final Boolean _learn;
        private final Boolean _unknownUnicastFlood;
        private final BridgeDomainKey key;
    
        BridgeDomainImpl(BridgeDomainBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new BridgeDomainKey(base.getName());
            }
            this._name = key.getName();
            this._arpTerminationTable = base.getArpTerminationTable();
            this._l2FibTable = base.getL2FibTable();
            this._arpTermination = base.isArpTermination();
            this._flood = base.isFlood();
            this._forward = base.isForward();
            this._learn = base.isLearn();
            this._unknownUnicastFlood = base.isUnknownUnicastFlood();
        }
    
        @Override
        public BridgeDomainKey key() {
            return key;
        }
        
        @Override
        public ArpTerminationTable getArpTerminationTable() {
            return _arpTerminationTable;
        }
        
        @Override
        public L2FibTable getL2FibTable() {
            return _l2FibTable;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Boolean isArpTermination() {
            return _arpTermination;
        }
        
        @Override
        public Boolean isFlood() {
            return _flood;
        }
        
        @Override
        public Boolean isForward() {
            return _forward;
        }
        
        @Override
        public Boolean isLearn() {
            return _learn;
        }
        
        @Override
        public Boolean isUnknownUnicastFlood() {
            return _unknownUnicastFlood;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_arpTerminationTable);
            result = prime * result + Objects.hashCode(_l2FibTable);
            result = prime * result + Objects.hashCode(_name);
            result = prime * result + Objects.hashCode(_arpTermination);
            result = prime * result + Objects.hashCode(_flood);
            result = prime * result + Objects.hashCode(_forward);
            result = prime * result + Objects.hashCode(_learn);
            result = prime * result + Objects.hashCode(_unknownUnicastFlood);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeDomain.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            BridgeDomain other = (BridgeDomain)obj;
            if (!Objects.equals(_arpTerminationTable, other.getArpTerminationTable())) {
                return false;
            }
            if (!Objects.equals(_l2FibTable, other.getL2FibTable())) {
                return false;
            }
            if (!Objects.equals(_name, other.getName())) {
                return false;
            }
            if (!Objects.equals(_arpTermination, other.isArpTermination())) {
                return false;
            }
            if (!Objects.equals(_flood, other.isFlood())) {
                return false;
            }
            if (!Objects.equals(_forward, other.isForward())) {
                return false;
            }
            if (!Objects.equals(_learn, other.isLearn())) {
                return false;
            }
            if (!Objects.equals(_unknownUnicastFlood, other.isUnknownUnicastFlood())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BridgeDomainImpl otherImpl = (BridgeDomainImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BridgeDomain");
            CodeHelpers.appendValue(helper, "_arpTerminationTable", _arpTerminationTable);
            CodeHelpers.appendValue(helper, "_l2FibTable", _l2FibTable);
            CodeHelpers.appendValue(helper, "_name", _name);
            CodeHelpers.appendValue(helper, "_arpTermination", _arpTermination);
            CodeHelpers.appendValue(helper, "_flood", _flood);
            CodeHelpers.appendValue(helper, "_forward", _forward);
            CodeHelpers.appendValue(helper, "_learn", _learn);
            CodeHelpers.appendValue(helper, "_unknownUnicastFlood", _unknownUnicastFlood);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
