package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GreBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GreBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new GreBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GreBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GreBuilder
 * @see Builder
 *
 */
public class GreBuilder implements Builder<Gre> {

    private IpAddress _dst;
    private Long _outerFibId;
    private IpAddress _src;


    Map<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> augmentation = Collections.emptyMap();

    public GreBuilder() {
    }
    public GreBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes arg) {
        this._src = arg.getSrc();
        this._dst = arg.getDst();
        this._outerFibId = arg.getOuterFibId();
    }

    public GreBuilder(Gre base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> aug =((AugmentationHolder<Gre>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dst = base.getDst();
        this._outerFibId = base.getOuterFibId();
        this._src = base.getSrc();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes) {
            this._src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes)arg).getSrc();
            this._dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes)arg).getDst();
            this._outerFibId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes)arg).getOuterFibId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.GreBaseAttributes]");
    }

    public IpAddress getDst() {
        return _dst;
    }
    
    public Long getOuterFibId() {
        return _outerFibId;
    }
    
    public IpAddress getSrc() {
        return _src;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Gre>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GreBuilder setDst(final IpAddress value) {
        this._dst = value;
        return this;
    }
    private static void checkOuterFibIdRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public GreBuilder setOuterFibId(final Long value) {
    if (value != null) {
        checkOuterFibIdRange(value);
        
    }
        this._outerFibId = value;
        return this;
    }
    
    public GreBuilder setSrc(final IpAddress value) {
        this._src = value;
        return this;
    }
    
    public GreBuilder addAugmentation(Class<? extends Augmentation<Gre>> augmentationType, Augmentation<Gre> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GreBuilder removeAugmentation(Class<? extends Augmentation<Gre>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Gre build() {
        return new GreImpl(this);
    }

    private static final class GreImpl
        extends AbstractAugmentable<Gre>
        implements Gre {
    
        private final IpAddress _dst;
        private final Long _outerFibId;
        private final IpAddress _src;
    
        GreImpl(GreBuilder base) {
            super(base.augmentation);
            this._dst = base.getDst();
            this._outerFibId = base.getOuterFibId();
            this._src = base.getSrc();
        }
    
        @Override
        public IpAddress getDst() {
            return _dst;
        }
        
        @Override
        public Long getOuterFibId() {
            return _outerFibId;
        }
        
        @Override
        public IpAddress getSrc() {
            return _src;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dst);
            result = prime * result + Objects.hashCode(_outerFibId);
            result = prime * result + Objects.hashCode(_src);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Gre.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Gre other = (Gre)obj;
            if (!Objects.equals(_dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(_outerFibId, other.getOuterFibId())) {
                return false;
            }
            if (!Objects.equals(_src, other.getSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GreImpl otherImpl = (GreImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Gre>>, Augmentation<Gre>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Gre");
            CodeHelpers.appendValue(helper, "_dst", _dst);
            CodeHelpers.appendValue(helper, "_outerFibId", _outerFibId);
            CodeHelpers.appendValue(helper, "_src", _src);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
