package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RoutingBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RoutingBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RoutingBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RoutingBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RoutingBuilder
 * @see Builder
 *
 */
public class RoutingBuilder implements Builder<Routing> {

    private Long _ipv4VrfId;
    private Long _ipv6VrfId;


    Map<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> augmentation = Collections.emptyMap();

    public RoutingBuilder() {
    }
    public RoutingBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes arg) {
        this._ipv4VrfId = arg.getIpv4VrfId();
        this._ipv6VrfId = arg.getIpv6VrfId();
    }

    public RoutingBuilder(Routing base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> aug =((AugmentationHolder<Routing>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ipv4VrfId = base.getIpv4VrfId();
        this._ipv6VrfId = base.getIpv6VrfId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes) {
            this._ipv4VrfId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes)arg).getIpv4VrfId();
            this._ipv6VrfId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes)arg).getIpv6VrfId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.RoutingBaseAttributes]");
    }

    public Long getIpv4VrfId() {
        return _ipv4VrfId;
    }
    
    public Long getIpv6VrfId() {
        return _ipv6VrfId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Routing>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkIpv4VrfIdRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public RoutingBuilder setIpv4VrfId(final Long value) {
    if (value != null) {
        checkIpv4VrfIdRange(value);
        
    }
        this._ipv4VrfId = value;
        return this;
    }
    private static void checkIpv6VrfIdRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public RoutingBuilder setIpv6VrfId(final Long value) {
    if (value != null) {
        checkIpv6VrfIdRange(value);
        
    }
        this._ipv6VrfId = value;
        return this;
    }
    
    public RoutingBuilder addAugmentation(Class<? extends Augmentation<Routing>> augmentationType, Augmentation<Routing> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RoutingBuilder removeAugmentation(Class<? extends Augmentation<Routing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Routing build() {
        return new RoutingImpl(this);
    }

    private static final class RoutingImpl
        extends AbstractAugmentable<Routing>
        implements Routing {
    
        private final Long _ipv4VrfId;
        private final Long _ipv6VrfId;
    
        RoutingImpl(RoutingBuilder base) {
            super(base.augmentation);
            this._ipv4VrfId = base.getIpv4VrfId();
            this._ipv6VrfId = base.getIpv6VrfId();
        }
    
        @Override
        public Long getIpv4VrfId() {
            return _ipv4VrfId;
        }
        
        @Override
        public Long getIpv6VrfId() {
            return _ipv6VrfId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ipv4VrfId);
            result = prime * result + Objects.hashCode(_ipv6VrfId);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Routing.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Routing other = (Routing)obj;
            if (!Objects.equals(_ipv4VrfId, other.getIpv4VrfId())) {
                return false;
            }
            if (!Objects.equals(_ipv6VrfId, other.getIpv6VrfId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RoutingImpl otherImpl = (RoutingImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Routing>>, Augmentation<Routing>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Routing");
            CodeHelpers.appendValue(helper, "_ipv4VrfId", _ipv4VrfId);
            CodeHelpers.appendValue(helper, "_ipv6VrfId", _ipv6VrfId);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
