package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserRole;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VhostUserBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VhostUserBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VhostUserBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VhostUserBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VhostUserBuilder
 * @see Builder
 *
 */
public class VhostUserBuilder implements Builder<VhostUser> {

    private String _connectError;
    private BigInteger _features;
    private Long _numMemoryRegions;
    private VhostUserRole _role;
    private String _socket;
    private String _tag;
    private Long _virtioNetHdrSize;


    Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> augmentation = Collections.emptyMap();

    public VhostUserBuilder() {
    }
    public VhostUserBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes arg) {
        this._socket = arg.getSocket();
        this._role = arg.getRole();
        this._tag = arg.getTag();
    }
    public VhostUserBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag arg) {
        this._tag = arg.getTag();
    }
    public VhostUserBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes arg) {
        this._features = arg.getFeatures();
        this._virtioNetHdrSize = arg.getVirtioNetHdrSize();
        this._numMemoryRegions = arg.getNumMemoryRegions();
        this._connectError = arg.getConnectError();
    }

    public VhostUserBuilder(VhostUser base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> aug =((AugmentationHolder<VhostUser>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._connectError = base.getConnectError();
        this._features = base.getFeatures();
        this._numMemoryRegions = base.getNumMemoryRegions();
        this._role = base.getRole();
        this._socket = base.getSocket();
        this._tag = base.getTag();
        this._virtioNetHdrSize = base.getVirtioNetHdrSize();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes) {
            this._features = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes)arg).getFeatures();
            this._virtioNetHdrSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes)arg).getVirtioNetHdrSize();
            this._numMemoryRegions = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes)arg).getNumMemoryRegions();
            this._connectError = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes)arg).getConnectError();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes) {
            this._socket = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes)arg).getSocket();
            this._role = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes)arg).getRole();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag) {
            this._tag = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag]");
    }

    public String getConnectError() {
        return _connectError;
    }
    
    public BigInteger getFeatures() {
        return _features;
    }
    
    public Long getNumMemoryRegions() {
        return _numMemoryRegions;
    }
    
    public VhostUserRole getRole() {
        return _role;
    }
    
    public String getSocket() {
        return _socket;
    }
    
    public String getTag() {
        return _tag;
    }
    
    public Long getVirtioNetHdrSize() {
        return _virtioNetHdrSize;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VhostUser>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public VhostUserBuilder setConnectError(final String value) {
        this._connectError = value;
        return this;
    }
    private static final Range<java.math.BigInteger>[] CHECKFEATURESRANGE_RANGES;
    static {
        @SuppressWarnings("unchecked")
        final Range<java.math.BigInteger>[] a = (Range<java.math.BigInteger>[]) Array.newInstance(Range.class, 1);
        a[0] = Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
        CHECKFEATURESRANGE_RANGES = a;
    }
    private static void checkFeaturesRange(final java.math.BigInteger value) {
        for (Range<java.math.BigInteger> r : CHECKFEATURESRANGE_RANGES) {
            if (r.contains(value)) {
                return;
            }
        }
        CodeHelpers.throwInvalidRange(CHECKFEATURESRANGE_RANGES, value);
    }
    
    public VhostUserBuilder setFeatures(final BigInteger value) {
    if (value != null) {
        checkFeaturesRange(value);
        
    }
        this._features = value;
        return this;
    }
    private static void checkNumMemoryRegionsRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public VhostUserBuilder setNumMemoryRegions(final Long value) {
    if (value != null) {
        checkNumMemoryRegionsRange(value);
        
    }
        this._numMemoryRegions = value;
        return this;
    }
    
    public VhostUserBuilder setRole(final VhostUserRole value) {
        this._role = value;
        return this;
    }
    private static void check_socketLength(final String value) {
        final int length = value.length();
        if (length >= 1 && length <= 255) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..255]]", value);
    }
    
    public VhostUserBuilder setSocket(final String value) {
    if (value != null) {
        check_socketLength(value);
        
    }
        this._socket = value;
        return this;
    }
    private static void check_tagLength(final String value) {
        final int length = value.length();
        if (length >= 1 && length <= 63) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..63]]", value);
    }
    
    public VhostUserBuilder setTag(final String value) {
    if (value != null) {
        check_tagLength(value);
        
    }
        this._tag = value;
        return this;
    }
    private static void checkVirtioNetHdrSizeRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public VhostUserBuilder setVirtioNetHdrSize(final Long value) {
    if (value != null) {
        checkVirtioNetHdrSizeRange(value);
        
    }
        this._virtioNetHdrSize = value;
        return this;
    }
    
    public VhostUserBuilder addAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType, Augmentation<VhostUser> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public VhostUserBuilder removeAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VhostUser build() {
        return new VhostUserImpl(this);
    }

    private static final class VhostUserImpl
        extends AbstractAugmentable<VhostUser>
        implements VhostUser {
    
        private final String _connectError;
        private final BigInteger _features;
        private final Long _numMemoryRegions;
        private final VhostUserRole _role;
        private final String _socket;
        private final String _tag;
        private final Long _virtioNetHdrSize;
    
        VhostUserImpl(VhostUserBuilder base) {
            super(base.augmentation);
            this._connectError = base.getConnectError();
            this._features = base.getFeatures();
            this._numMemoryRegions = base.getNumMemoryRegions();
            this._role = base.getRole();
            this._socket = base.getSocket();
            this._tag = base.getTag();
            this._virtioNetHdrSize = base.getVirtioNetHdrSize();
        }
    
        @Override
        public String getConnectError() {
            return _connectError;
        }
        
        @Override
        public BigInteger getFeatures() {
            return _features;
        }
        
        @Override
        public Long getNumMemoryRegions() {
            return _numMemoryRegions;
        }
        
        @Override
        public VhostUserRole getRole() {
            return _role;
        }
        
        @Override
        public String getSocket() {
            return _socket;
        }
        
        @Override
        public String getTag() {
            return _tag;
        }
        
        @Override
        public Long getVirtioNetHdrSize() {
            return _virtioNetHdrSize;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_connectError);
            result = prime * result + Objects.hashCode(_features);
            result = prime * result + Objects.hashCode(_numMemoryRegions);
            result = prime * result + Objects.hashCode(_role);
            result = prime * result + Objects.hashCode(_socket);
            result = prime * result + Objects.hashCode(_tag);
            result = prime * result + Objects.hashCode(_virtioNetHdrSize);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VhostUser.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            VhostUser other = (VhostUser)obj;
            if (!Objects.equals(_connectError, other.getConnectError())) {
                return false;
            }
            if (!Objects.equals(_features, other.getFeatures())) {
                return false;
            }
            if (!Objects.equals(_numMemoryRegions, other.getNumMemoryRegions())) {
                return false;
            }
            if (!Objects.equals(_role, other.getRole())) {
                return false;
            }
            if (!Objects.equals(_socket, other.getSocket())) {
                return false;
            }
            if (!Objects.equals(_tag, other.getTag())) {
                return false;
            }
            if (!Objects.equals(_virtioNetHdrSize, other.getVirtioNetHdrSize())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                VhostUserImpl otherImpl = (VhostUserImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("VhostUser");
            CodeHelpers.appendValue(helper, "_connectError", _connectError);
            CodeHelpers.appendValue(helper, "_features", _features);
            CodeHelpers.appendValue(helper, "_numMemoryRegions", _numMemoryRegions);
            CodeHelpers.appendValue(helper, "_role", _role);
            CodeHelpers.appendValue(helper, "_socket", _socket);
            CodeHelpers.appendValue(helper, "_tag", _tag);
            CodeHelpers.appendValue(helper, "_virtioNetHdrSize", _virtioNetHdrSize);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
