package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeNextProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeVni;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VxlanGpeBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VxlanGpeBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VxlanGpeBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VxlanGpeBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VxlanGpeBuilder
 * @see Builder
 *
 */
public class VxlanGpeBuilder implements Builder<VxlanGpe> {

    private Long _decapVrfId;
    private Long _encapVrfId;
    private IpAddress _local;
    private VxlanGpeNextProtocol _nextProtocol;
    private IpAddress _remote;
    private VxlanGpeVni _vni;


    Map<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> augmentation = Collections.emptyMap();

    public VxlanGpeBuilder() {
    }
    public VxlanGpeBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes arg) {
        this._local = arg.getLocal();
        this._remote = arg.getRemote();
        this._vni = arg.getVni();
        this._nextProtocol = arg.getNextProtocol();
        this._encapVrfId = arg.getEncapVrfId();
        this._decapVrfId = arg.getDecapVrfId();
    }

    public VxlanGpeBuilder(VxlanGpe base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> aug =((AugmentationHolder<VxlanGpe>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._decapVrfId = base.getDecapVrfId();
        this._encapVrfId = base.getEncapVrfId();
        this._local = base.getLocal();
        this._nextProtocol = base.getNextProtocol();
        this._remote = base.getRemote();
        this._vni = base.getVni();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes) {
            this._local = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getLocal();
            this._remote = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getRemote();
            this._vni = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getVni();
            this._nextProtocol = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getNextProtocol();
            this._encapVrfId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getEncapVrfId();
            this._decapVrfId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes)arg).getDecapVrfId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes]");
    }

    public Long getDecapVrfId() {
        return _decapVrfId;
    }
    
    public Long getEncapVrfId() {
        return _encapVrfId;
    }
    
    public IpAddress getLocal() {
        return _local;
    }
    
    public VxlanGpeNextProtocol getNextProtocol() {
        return _nextProtocol;
    }
    
    public IpAddress getRemote() {
        return _remote;
    }
    
    public VxlanGpeVni getVni() {
        return _vni;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VxlanGpe>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDecapVrfIdRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public VxlanGpeBuilder setDecapVrfId(final Long value) {
    if (value != null) {
        checkDecapVrfIdRange(value);
        
    }
        this._decapVrfId = value;
        return this;
    }
    private static void checkEncapVrfIdRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public VxlanGpeBuilder setEncapVrfId(final Long value) {
    if (value != null) {
        checkEncapVrfIdRange(value);
        
    }
        this._encapVrfId = value;
        return this;
    }
    
    public VxlanGpeBuilder setLocal(final IpAddress value) {
        this._local = value;
        return this;
    }
    
    public VxlanGpeBuilder setNextProtocol(final VxlanGpeNextProtocol value) {
        this._nextProtocol = value;
        return this;
    }
    
    public VxlanGpeBuilder setRemote(final IpAddress value) {
        this._remote = value;
        return this;
    }
    
    public VxlanGpeBuilder setVni(final VxlanGpeVni value) {
        this._vni = value;
        return this;
    }
    
    public VxlanGpeBuilder addAugmentation(Class<? extends Augmentation<VxlanGpe>> augmentationType, Augmentation<VxlanGpe> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public VxlanGpeBuilder removeAugmentation(Class<? extends Augmentation<VxlanGpe>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VxlanGpe build() {
        return new VxlanGpeImpl(this);
    }

    private static final class VxlanGpeImpl
        extends AbstractAugmentable<VxlanGpe>
        implements VxlanGpe {
    
        private final Long _decapVrfId;
        private final Long _encapVrfId;
        private final IpAddress _local;
        private final VxlanGpeNextProtocol _nextProtocol;
        private final IpAddress _remote;
        private final VxlanGpeVni _vni;
    
        VxlanGpeImpl(VxlanGpeBuilder base) {
            super(base.augmentation);
            this._decapVrfId = base.getDecapVrfId();
            this._encapVrfId = base.getEncapVrfId();
            this._local = base.getLocal();
            this._nextProtocol = base.getNextProtocol();
            this._remote = base.getRemote();
            this._vni = base.getVni();
        }
    
        @Override
        public Long getDecapVrfId() {
            return _decapVrfId;
        }
        
        @Override
        public Long getEncapVrfId() {
            return _encapVrfId;
        }
        
        @Override
        public IpAddress getLocal() {
            return _local;
        }
        
        @Override
        public VxlanGpeNextProtocol getNextProtocol() {
            return _nextProtocol;
        }
        
        @Override
        public IpAddress getRemote() {
            return _remote;
        }
        
        @Override
        public VxlanGpeVni getVni() {
            return _vni;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_decapVrfId);
            result = prime * result + Objects.hashCode(_encapVrfId);
            result = prime * result + Objects.hashCode(_local);
            result = prime * result + Objects.hashCode(_nextProtocol);
            result = prime * result + Objects.hashCode(_remote);
            result = prime * result + Objects.hashCode(_vni);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VxlanGpe.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            VxlanGpe other = (VxlanGpe)obj;
            if (!Objects.equals(_decapVrfId, other.getDecapVrfId())) {
                return false;
            }
            if (!Objects.equals(_encapVrfId, other.getEncapVrfId())) {
                return false;
            }
            if (!Objects.equals(_local, other.getLocal())) {
                return false;
            }
            if (!Objects.equals(_nextProtocol, other.getNextProtocol())) {
                return false;
            }
            if (!Objects.equals(_remote, other.getRemote())) {
                return false;
            }
            if (!Objects.equals(_vni, other.getVni())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                VxlanGpeImpl otherImpl = (VxlanGpeImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("VxlanGpe");
            CodeHelpers.appendValue(helper, "_decapVrfId", _decapVrfId);
            CodeHelpers.appendValue(helper, "_encapVrfId", _encapVrfId);
            CodeHelpers.appendValue(helper, "_local", _local);
            CodeHelpers.appendValue(helper, "_nextProtocol", _nextProtocol);
            CodeHelpers.appendValue(helper, "_remote", _remote);
            CodeHelpers.appendValue(helper, "_vni", _vni);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
