package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.config.attributes.interconnection;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BridgeBasedBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BridgeBasedBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new BridgeBasedBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BridgeBasedBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BridgeBasedBuilder
 * @see Builder
 *
 */
public class BridgeBasedBuilder implements Builder<BridgeBased> {

    private String _bridgeDomain;
    private Short _splitHorizonGroup;
    private Boolean _bridgedVirtualInterface;


    Map<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> augmentation = Collections.emptyMap();

    public BridgeBasedBuilder() {
    }
    public BridgeBasedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes arg) {
        this._bridgeDomain = arg.getBridgeDomain();
        this._splitHorizonGroup = arg.getSplitHorizonGroup();
        this._bridgedVirtualInterface = arg.isBridgedVirtualInterface();
    }

    public BridgeBasedBuilder(BridgeBased base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> aug =((AugmentationHolder<BridgeBased>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._bridgeDomain = base.getBridgeDomain();
        this._splitHorizonGroup = base.getSplitHorizonGroup();
        this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes) {
            this._bridgeDomain = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes)arg).getBridgeDomain();
            this._splitHorizonGroup = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes)arg).getSplitHorizonGroup();
            this._bridgedVirtualInterface = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes)arg).isBridgedVirtualInterface();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeBasedAttributes]");
    }

    public String getBridgeDomain() {
        return _bridgeDomain;
    }
    
    public Short getSplitHorizonGroup() {
        return _splitHorizonGroup;
    }
    
    public Boolean isBridgedVirtualInterface() {
        return _bridgedVirtualInterface;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BridgeBased>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public BridgeBasedBuilder setBridgeDomain(final String value) {
        this._bridgeDomain = value;
        return this;
    }
    private static void checkSplitHorizonGroupRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public BridgeBasedBuilder setSplitHorizonGroup(final Short value) {
    if (value != null) {
        checkSplitHorizonGroupRange(value);
        
    }
        this._splitHorizonGroup = value;
        return this;
    }
    
    public BridgeBasedBuilder setBridgedVirtualInterface(final Boolean value) {
        this._bridgedVirtualInterface = value;
        return this;
    }
    
    public BridgeBasedBuilder addAugmentation(Class<? extends Augmentation<BridgeBased>> augmentationType, Augmentation<BridgeBased> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BridgeBasedBuilder removeAugmentation(Class<? extends Augmentation<BridgeBased>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BridgeBased build() {
        return new BridgeBasedImpl(this);
    }

    private static final class BridgeBasedImpl
        extends AbstractAugmentable<BridgeBased>
        implements BridgeBased {
    
        private final String _bridgeDomain;
        private final Short _splitHorizonGroup;
        private final Boolean _bridgedVirtualInterface;
    
        BridgeBasedImpl(BridgeBasedBuilder base) {
            super(base.augmentation);
            this._bridgeDomain = base.getBridgeDomain();
            this._splitHorizonGroup = base.getSplitHorizonGroup();
            this._bridgedVirtualInterface = base.isBridgedVirtualInterface();
        }
    
        @Override
        public String getBridgeDomain() {
            return _bridgeDomain;
        }
        
        @Override
        public Short getSplitHorizonGroup() {
            return _splitHorizonGroup;
        }
        
        @Override
        public Boolean isBridgedVirtualInterface() {
            return _bridgedVirtualInterface;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bridgeDomain);
            result = prime * result + Objects.hashCode(_splitHorizonGroup);
            result = prime * result + Objects.hashCode(_bridgedVirtualInterface);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BridgeBased.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            BridgeBased other = (BridgeBased)obj;
            if (!Objects.equals(_bridgeDomain, other.getBridgeDomain())) {
                return false;
            }
            if (!Objects.equals(_splitHorizonGroup, other.getSplitHorizonGroup())) {
                return false;
            }
            if (!Objects.equals(_bridgedVirtualInterface, other.isBridgedVirtualInterface())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BridgeBasedImpl otherImpl = (BridgeBasedImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BridgeBased>>, Augmentation<BridgeBased>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BridgeBased");
            CodeHelpers.appendValue(helper, "_bridgeDomain", _bridgeDomain);
            CodeHelpers.appendValue(helper, "_splitHorizonGroup", _splitHorizonGroup);
            CodeHelpers.appendValue(helper, "_bridgedVirtualInterface", _bridgedVirtualInterface);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
