package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.l2.fib.table.L2FibEntry;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * container l2-fib-table {
 *   list l2-fib-entry {
 *     key phys-address;
 *     leaf phys-address {
 *       type yang:phys-address;
 *     }
 *     leaf outgoing-interface {
 *       when "../action != 'l2-fib-filter'";
 *       type if:interface-ref;
 *     }
 *     leaf static-config {
 *       type boolean;
 *       default false;
 *     }
 *     leaf action {
 *       type l2-fib-action;
 *     }
 *     leaf bridged-virtual-interface {
 *       when "../action = 'forward'";
 *       type boolean;
 *       config false;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/l2-fib-attributes/l2-fib-table</i>
 *
 * <p>To create instances of this class use {@link L2FibTableBuilder}.
 * @see L2FibTableBuilder
 *
 */
public interface L2FibTable
    extends
    ChildOf<L2FibAttributes>,
    Augmentable<L2FibTable>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("l2-fib-table");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>l2FibEntry</code>, or <code>null</code> if not present
     */
    @Nullable List<L2FibEntry> getL2FibEntry();
    
    /**
     * @return <code>java.util.List</code> <code>l2FibEntry</code>, or an empty list if it is not present
     */
    default @NonNull List<L2FibEntry> nonnullL2FibEntry() {
        return CodeHelpers.nonnull(getL2FibEntry());
    }

}

