package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.l2.fib.table;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * list l2-fib-entry {
 *   key phys-address;
 *   leaf phys-address {
 *     type yang:phys-address;
 *   }
 *   leaf outgoing-interface {
 *     when "../action != 'l2-fib-filter'";
 *     type if:interface-ref;
 *   }
 *   leaf static-config {
 *     type boolean;
 *     default false;
 *   }
 *   leaf action {
 *     type l2-fib-action;
 *   }
 *   leaf bridged-virtual-interface {
 *     when "../action = 'forward'";
 *     type boolean;
 *     config false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/l2-fib-attributes/l2-fib-table/l2-fib-entry</i>
 *
 * <p>To create instances of this class use {@link L2FibEntryBuilder}.
 * @see L2FibEntryBuilder
 * @see L2FibEntryKey
 *
 */
public interface L2FibEntry
    extends
    ChildOf<L2FibTable>,
    Augmentable<L2FibEntry>,
    Identifiable<L2FibEntryKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("l2-fib-entry");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.l2.fib.table.L2FibEntry> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.l2.fib.table.L2FibEntry.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress</code> <code>physAddress</code>, or <code>null</code> if not present
     */
    @Nullable PhysAddress getPhysAddress();
    
    /**
     * One of interfaces assigned to the FIB table's bridge-domain.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>outgoingInterface</code>, or <code>null</code> if not present
     */
    @Nullable String getOutgoingInterface();
    
    /**
     * Static entries cannot be overridden by mac learning.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>staticConfig</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isStaticConfig();
    
    /**
     * L2 FIB action. For filter action, entry must be configured as static.
     *
     *
     *
     * @return <code>java.lang.Class</code> <code>action</code>, or <code>null</code> if not present
     */
    @Nullable Class<? extends L2FibAction> getAction();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>bridgedVirtualInterface</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isBridgedVirtualInterface();
    
    @Override
    L2FibEntryKey key();

}

