package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.l2.fib.table;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class L2FibEntryKey
 implements Identifier<L2FibEntry> {
    private static final long serialVersionUID = 4710568846510449439L;
    private final PhysAddress _physAddress;


    public L2FibEntryKey(PhysAddress _physAddress) {
    
    
        this._physAddress = _physAddress;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public L2FibEntryKey(L2FibEntryKey source) {
        this._physAddress = source._physAddress;
    }


    public PhysAddress getPhysAddress() {
        return _physAddress;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_physAddress);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        L2FibEntryKey other = (L2FibEntryKey) obj;
        if (!Objects.equals(_physAddress, other._physAddress)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(L2FibEntryKey.class);
        CodeHelpers.appendValue(helper, "_physAddress", _physAddress);
        return helper.toString();
    }
}

