package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.state.attributes.interconnection;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link XconnectBasedBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     XconnectBasedBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new XconnectBasedBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of XconnectBasedBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see XconnectBasedBuilder
 * @see Builder
 *
 */
public class XconnectBasedBuilder implements Builder<XconnectBased> {

    private String _xconnectOutgoingInterface;


    Map<Class<? extends Augmentation<XconnectBased>>, Augmentation<XconnectBased>> augmentation = Collections.emptyMap();

    public XconnectBasedBuilder() {
    }

    public XconnectBasedBuilder(XconnectBased base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<XconnectBased>>, Augmentation<XconnectBased>> aug =((AugmentationHolder<XconnectBased>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._xconnectOutgoingInterface = base.getXconnectOutgoingInterface();
    }


    public String getXconnectOutgoingInterface() {
        return _xconnectOutgoingInterface;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<XconnectBased>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public XconnectBasedBuilder setXconnectOutgoingInterface(final String value) {
        this._xconnectOutgoingInterface = value;
        return this;
    }
    
    public XconnectBasedBuilder addAugmentation(Class<? extends Augmentation<XconnectBased>> augmentationType, Augmentation<XconnectBased> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public XconnectBasedBuilder removeAugmentation(Class<? extends Augmentation<XconnectBased>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public XconnectBased build() {
        return new XconnectBasedImpl(this);
    }

    private static final class XconnectBasedImpl
        extends AbstractAugmentable<XconnectBased>
        implements XconnectBased {
    
        private final String _xconnectOutgoingInterface;
    
        XconnectBasedImpl(XconnectBasedBuilder base) {
            super(base.augmentation);
            this._xconnectOutgoingInterface = base.getXconnectOutgoingInterface();
        }
    
        @Override
        public String getXconnectOutgoingInterface() {
            return _xconnectOutgoingInterface;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_xconnectOutgoingInterface);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!XconnectBased.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            XconnectBased other = (XconnectBased)obj;
            if (!Objects.equals(_xconnectOutgoingInterface, other.getXconnectOutgoingInterface())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                XconnectBasedImpl otherImpl = (XconnectBasedImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<XconnectBased>>, Augmentation<XconnectBased>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("XconnectBased");
            CodeHelpers.appendValue(helper, "_xconnectOutgoingInterface", _xconnectOutgoingInterface);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
