package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.attributes.mirrored.interfaces;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class MirroredInterfaceKey
 implements Identifier<MirroredInterface> {
    private static final long serialVersionUID = 5668799281424489043L;
    private final String _ifaceRef;


    public MirroredInterfaceKey(String _ifaceRef) {
    
    
        this._ifaceRef = _ifaceRef;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MirroredInterfaceKey(MirroredInterfaceKey source) {
        this._ifaceRef = source._ifaceRef;
    }


    public String getIfaceRef() {
        return _ifaceRef;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_ifaceRef);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        MirroredInterfaceKey other = (MirroredInterfaceKey) obj;
        if (!Objects.equals(_ifaceRef, other._ifaceRef)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MirroredInterfaceKey.class);
        CodeHelpers.appendValue(helper, "_ifaceRef", _ifaceRef);
        return helper.toString();
    }
}

