package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.SpanStateAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes.mirrored.interfaces.MirroredInterface;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * container mirrored-interfaces {
 *   list mirrored-interface {
 *     key iface-ref;
 *     leaf iface-ref {
 *       type if:interface-state-ref;
 *     }
 *     leaf state {
 *       type span-state;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/span-state-attributes/mirrored-interfaces</i>
 *
 * <p>To create instances of this class use {@link MirroredInterfacesBuilder}.
 * @see MirroredInterfacesBuilder
 *
 */
public interface MirroredInterfaces
    extends
    ChildOf<SpanStateAttributes>,
    Augmentable<MirroredInterfaces>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mirrored-interfaces");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes.MirroredInterfaces> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes.MirroredInterfaces.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>mirroredInterface</code>, or <code>null</code> if not present
     */
    @Nullable List<MirroredInterface> getMirroredInterface();
    
    /**
     * @return <code>java.util.List</code> <code>mirroredInterface</code>, or an empty list if it is not present
     */
    default @NonNull List<MirroredInterface> nonnullMirroredInterface() {
        return CodeHelpers.nonnull(getMirroredInterface());
    }

}

