package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point.InterfaceType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TerminationPointVbridgeAugmentBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TerminationPointVbridgeAugmentBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TerminationPointVbridgeAugmentBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TerminationPointVbridgeAugmentBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TerminationPointVbridgeAugmentBuilder
 * @see Builder
 *
 */
public class TerminationPointVbridgeAugmentBuilder implements Builder<TerminationPointVbridgeAugment> {

    private InterfaceType _interfaceType;



    public TerminationPointVbridgeAugmentBuilder() {
    }

    public TerminationPointVbridgeAugmentBuilder(TerminationPointVbridgeAugment base) {
        this._interfaceType = base.getInterfaceType();
    }


    public InterfaceType getInterfaceType() {
        return _interfaceType;
    }

    
    public TerminationPointVbridgeAugmentBuilder setInterfaceType(final InterfaceType value) {
        this._interfaceType = value;
        return this;
    }
    

    @Override
    public TerminationPointVbridgeAugment build() {
        return new TerminationPointVbridgeAugmentImpl(this);
    }

    private static final class TerminationPointVbridgeAugmentImpl
        implements TerminationPointVbridgeAugment {
    
        private final InterfaceType _interfaceType;
    
        TerminationPointVbridgeAugmentImpl(TerminationPointVbridgeAugmentBuilder base) {
            this._interfaceType = base.getInterfaceType();
        }
    
        @Override
        public InterfaceType getInterfaceType() {
            return _interfaceType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_interfaceType);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TerminationPointVbridgeAugment.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            TerminationPointVbridgeAugment other = (TerminationPointVbridgeAugment)obj;
            if (!Objects.equals(_interfaceType, other.getInterfaceType())) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TerminationPointVbridgeAugment");
            CodeHelpers.appendValue(helper, "_interfaceType", _interfaceType);
            return helper.toString();
        }
    }
}
