package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point.InterfaceTypeCfg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TerminationPointVbridgeCfgAugmentBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TerminationPointVbridgeCfgAugmentBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TerminationPointVbridgeCfgAugmentBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TerminationPointVbridgeCfgAugmentBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TerminationPointVbridgeCfgAugmentBuilder
 * @see Builder
 *
 */
public class TerminationPointVbridgeCfgAugmentBuilder implements Builder<TerminationPointVbridgeCfgAugment> {

    private InterfaceTypeCfg _interfaceTypeCfg;



    public TerminationPointVbridgeCfgAugmentBuilder() {
    }

    public TerminationPointVbridgeCfgAugmentBuilder(TerminationPointVbridgeCfgAugment base) {
        this._interfaceTypeCfg = base.getInterfaceTypeCfg();
    }


    public InterfaceTypeCfg getInterfaceTypeCfg() {
        return _interfaceTypeCfg;
    }

    
    public TerminationPointVbridgeCfgAugmentBuilder setInterfaceTypeCfg(final InterfaceTypeCfg value) {
        this._interfaceTypeCfg = value;
        return this;
    }
    

    @Override
    public TerminationPointVbridgeCfgAugment build() {
        return new TerminationPointVbridgeCfgAugmentImpl(this);
    }

    private static final class TerminationPointVbridgeCfgAugmentImpl
        implements TerminationPointVbridgeCfgAugment {
    
        private final InterfaceTypeCfg _interfaceTypeCfg;
    
        TerminationPointVbridgeCfgAugmentImpl(TerminationPointVbridgeCfgAugmentBuilder base) {
            this._interfaceTypeCfg = base.getInterfaceTypeCfg();
        }
    
        @Override
        public InterfaceTypeCfg getInterfaceTypeCfg() {
            return _interfaceTypeCfg;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_interfaceTypeCfg);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TerminationPointVbridgeCfgAugment.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            TerminationPointVbridgeCfgAugment other = (TerminationPointVbridgeCfgAugment)obj;
            if (!Objects.equals(_interfaceTypeCfg, other.getInterfaceTypeCfg())) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TerminationPointVbridgeCfgAugment");
            CodeHelpers.appendValue(helper, "_interfaceTypeCfg", _interfaceTypeCfg);
            return helper.toString();
        }
    }
}
