package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.TunnelParameters;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TopologyVbridgeAugmentBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TopologyVbridgeAugmentBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TopologyVbridgeAugmentBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TopologyVbridgeAugmentBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TopologyVbridgeAugmentBuilder
 * @see Builder
 *
 */
public class TopologyVbridgeAugmentBuilder implements Builder<TopologyVbridgeAugment> {

    private ArpTerminationTable _arpTerminationTable;
    private TunnelParameters _tunnelParameters;
    private Class<? extends TunnelType> _tunnelType;
    private Boolean _arpTermination;
    private Boolean _flood;
    private Boolean _forward;
    private Boolean _learn;
    private Boolean _unknownUnicastFlood;



    public TopologyVbridgeAugmentBuilder() {
    }
    public TopologyVbridgeAugmentBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes arg) {
        this._flood = arg.isFlood();
        this._forward = arg.isForward();
        this._learn = arg.isLearn();
        this._unknownUnicastFlood = arg.isUnknownUnicastFlood();
        this._arpTermination = arg.isArpTermination();
        this._arpTerminationTable = arg.getArpTerminationTable();
    }

    public TopologyVbridgeAugmentBuilder(TopologyVbridgeAugment base) {
        this._arpTerminationTable = base.getArpTerminationTable();
        this._tunnelParameters = base.getTunnelParameters();
        this._tunnelType = base.getTunnelType();
        this._arpTermination = base.isArpTermination();
        this._flood = base.isFlood();
        this._forward = base.isForward();
        this._learn = base.isLearn();
        this._unknownUnicastFlood = base.isUnknownUnicastFlood();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes) {
            this._flood = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isFlood();
            this._forward = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isForward();
            this._learn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isLearn();
            this._unknownUnicastFlood = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isUnknownUnicastFlood();
            this._arpTermination = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).isArpTermination();
            this._arpTerminationTable = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes)arg).getArpTerminationTable();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes]");
    }

    public ArpTerminationTable getArpTerminationTable() {
        return _arpTerminationTable;
    }
    
    public TunnelParameters getTunnelParameters() {
        return _tunnelParameters;
    }
    
    public Class<? extends TunnelType> getTunnelType() {
        return _tunnelType;
    }
    
    public Boolean isArpTermination() {
        return _arpTermination;
    }
    
    public Boolean isFlood() {
        return _flood;
    }
    
    public Boolean isForward() {
        return _forward;
    }
    
    public Boolean isLearn() {
        return _learn;
    }
    
    public Boolean isUnknownUnicastFlood() {
        return _unknownUnicastFlood;
    }

    
    public TopologyVbridgeAugmentBuilder setArpTerminationTable(final ArpTerminationTable value) {
        this._arpTerminationTable = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setTunnelParameters(final TunnelParameters value) {
        this._tunnelParameters = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setTunnelType(final Class<? extends TunnelType> value) {
        this._tunnelType = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setArpTermination(final Boolean value) {
        this._arpTermination = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setFlood(final Boolean value) {
        this._flood = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setForward(final Boolean value) {
        this._forward = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setLearn(final Boolean value) {
        this._learn = value;
        return this;
    }
    
    public TopologyVbridgeAugmentBuilder setUnknownUnicastFlood(final Boolean value) {
        this._unknownUnicastFlood = value;
        return this;
    }
    

    @Override
    public TopologyVbridgeAugment build() {
        return new TopologyVbridgeAugmentImpl(this);
    }

    private static final class TopologyVbridgeAugmentImpl
        implements TopologyVbridgeAugment {
    
        private final ArpTerminationTable _arpTerminationTable;
        private final TunnelParameters _tunnelParameters;
        private final Class<? extends TunnelType> _tunnelType;
        private final Boolean _arpTermination;
        private final Boolean _flood;
        private final Boolean _forward;
        private final Boolean _learn;
        private final Boolean _unknownUnicastFlood;
    
        TopologyVbridgeAugmentImpl(TopologyVbridgeAugmentBuilder base) {
            this._arpTerminationTable = base.getArpTerminationTable();
            this._tunnelParameters = base.getTunnelParameters();
            this._tunnelType = base.getTunnelType();
            this._arpTermination = base.isArpTermination();
            this._flood = base.isFlood();
            this._forward = base.isForward();
            this._learn = base.isLearn();
            this._unknownUnicastFlood = base.isUnknownUnicastFlood();
        }
    
        @Override
        public ArpTerminationTable getArpTerminationTable() {
            return _arpTerminationTable;
        }
        
        @Override
        public TunnelParameters getTunnelParameters() {
            return _tunnelParameters;
        }
        
        @Override
        public Class<? extends TunnelType> getTunnelType() {
            return _tunnelType;
        }
        
        @Override
        public Boolean isArpTermination() {
            return _arpTermination;
        }
        
        @Override
        public Boolean isFlood() {
            return _flood;
        }
        
        @Override
        public Boolean isForward() {
            return _forward;
        }
        
        @Override
        public Boolean isLearn() {
            return _learn;
        }
        
        @Override
        public Boolean isUnknownUnicastFlood() {
            return _unknownUnicastFlood;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_arpTerminationTable);
            result = prime * result + Objects.hashCode(_tunnelParameters);
            result = prime * result + Objects.hashCode(_tunnelType);
            result = prime * result + Objects.hashCode(_arpTermination);
            result = prime * result + Objects.hashCode(_flood);
            result = prime * result + Objects.hashCode(_forward);
            result = prime * result + Objects.hashCode(_learn);
            result = prime * result + Objects.hashCode(_unknownUnicastFlood);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TopologyVbridgeAugment.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            TopologyVbridgeAugment other = (TopologyVbridgeAugment)obj;
            if (!Objects.equals(_arpTerminationTable, other.getArpTerminationTable())) {
                return false;
            }
            if (!Objects.equals(_tunnelParameters, other.getTunnelParameters())) {
                return false;
            }
            if (!Objects.equals(_tunnelType, other.getTunnelType())) {
                return false;
            }
            if (!Objects.equals(_arpTermination, other.isArpTermination())) {
                return false;
            }
            if (!Objects.equals(_flood, other.isFlood())) {
                return false;
            }
            if (!Objects.equals(_forward, other.isForward())) {
                return false;
            }
            if (!Objects.equals(_learn, other.isLearn())) {
                return false;
            }
            if (!Objects.equals(_unknownUnicastFlood, other.isUnknownUnicastFlood())) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TopologyVbridgeAugment");
            CodeHelpers.appendValue(helper, "_arpTerminationTable", _arpTerminationTable);
            CodeHelpers.appendValue(helper, "_tunnelParameters", _tunnelParameters);
            CodeHelpers.appendValue(helper, "_tunnelType", _tunnelType);
            CodeHelpers.appendValue(helper, "_arpTermination", _arpTermination);
            CodeHelpers.appendValue(helper, "_flood", _flood);
            CodeHelpers.appendValue(helper, "_forward", _forward);
            CodeHelpers.appendValue(helper, "_learn", _learn);
            CodeHelpers.appendValue(helper, "_unknownUnicastFlood", _unknownUnicastFlood);
            return helper.toString();
        }
    }
}
