package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.TopologyVbridgeCfgAugment;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Topology used for displaying startup VBridge nodes configuration defined in ODL.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>vbridge-topology</b>
 * <pre>
 * container vbridge-startup-config {
 *   presence "Label for startup config.";
 * }
 * </pre>The schema path to identify an instance is
 * <i>vbridge-topology/network-topology/topology/(urn:opendaylight:params:xml:ns:yang:vbridge:topology?revision=2016-01-29)vbridge-startup-config</i>
 *
 * <p>To create instances of this class use {@link VbridgeStartupConfigBuilder}.
 * @see VbridgeStartupConfigBuilder
 *
 */
public interface VbridgeStartupConfig
    extends
    ChildOf<TopologyVbridgeCfgAugment>,
    Augmentable<VbridgeStartupConfig>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vbridge-startup-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.VbridgeStartupConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.VbridgeStartupConfig.class;
    }

}

