package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.external.reference.rev160129.ExternalReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.NodeVbridgeAugment;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>vbridge-topology</b>
 * <pre>
 * container bridge-member {
 *   presence "Indicates this node is part of the bridge domain";
 *   must ../../nt:supporting-node;
 *   leaf supporting-bridge-domain {
 *     config false;
 *     type extref:external-reference;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>vbridge-topology/network-topology/topology/node/(urn:opendaylight:params:xml:ns:yang:vbridge:topology?revision=2016-01-29)bridge-member</i>
 *
 * <p>To create instances of this class use {@link BridgeMemberBuilder}.
 * @see BridgeMemberBuilder
 *
 */
public interface BridgeMember
    extends
    ChildOf<NodeVbridgeAugment>,
    Augmentable<BridgeMember>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bridge-member");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.BridgeMember> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.BridgeMember.class;
    }
    
    /**
     * Reference to the network element bridge domain, which has been configured to
     * support this virtual bridge domain on this bridge member. This reference needs
     * to be resolved against the supporting node's configuration data store.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.external.reference.rev160129.ExternalReference</code> <code>supportingBridgeDomain</code>, or <code>null</code> if not present
     */
    @Nullable ExternalReference getSupportingBridgeDomain();

}

