package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.external.reference.rev160129.ExternalReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point.InterfaceType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>vbridge-topology</b>
 * <pre>
 * case user-interface {
 *   leaf user-interface {
 *     type extref:external-reference;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>vbridge-topology/network-topology/topology/node/termination-point/(urn:opendaylight:params:xml:ns:yang:vbridge:topology?revision=2016-01-29)interface-type/user-interface</i>
 *
 */
public interface UserInterface
    extends
    DataObject,
    Augmentable<UserInterface>,
    InterfaceType
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("user-interface");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type.UserInterface> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type.UserInterface.class;
    }
    
    /**
     * Reference to the network element interface, which is configured to be a member
     * of this virtual bridge domain. This reference needs to be resolved against the
     * supporting node's configuration data store.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.external.reference.rev160129.ExternalReference</code> <code>userInterface</code>, or <code>null</code> if not present
     */
    @Nullable ExternalReference getUserInterface();

}

