package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type.cfg.virtual.domain.carrier._case;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Reference to the physical network element interface, which can be used as a 
 * super interface for VLAN sub-interfaces or which IP address can be specified as 
 * a source or destination of encapsulated VXLAN traffic.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>vbridge-topology</b>
 * <pre>
 * container virtual-domain-carrier {
 *   presence "Label for startup config.";
 *   config false;
 * }
 * </pre>The schema path to identify an instance is
 * <i>vbridge-topology/network-topology/topology/node/termination-point/(urn:opendaylight:params:xml:ns:yang:vbridge:topology?revision=2016-01-29)interface-type-cfg/virtual-domain-carrier-case/virtual-domain-carrier</i>
 *
 * <p>To create instances of this class use {@link VirtualDomainCarrierBuilder}.
 * @see VirtualDomainCarrierBuilder
 *
 */
public interface VirtualDomainCarrier
    extends
    ChildOf<TerminationPoint>,
    Augmentable<VirtualDomainCarrier>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("virtual-domain-carrier");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type.cfg.virtual.domain.carrier._case.VirtualDomainCarrier> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.node.termination.point._interface.type.cfg.virtual.domain.carrier._case.VirtualDomainCarrier.class;
    }

}

