/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron;

import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.locatorrecords.LocatorRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecordBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.AddKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.AddKeyInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.AddMappingInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.AddMappingInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.GetMappingInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.GetMappingInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveKeyInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveMappingInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveMappingInputBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;

public final class LispUtil {
    private LispUtil() {
    }

    public static AddMappingInput buildAddMappingInput(Eid eid, List<LocatorRecord> locators) {
        MappingRecordBuilder mrb = new MappingRecordBuilder();
        mrb.setAction(MappingRecord.Action.NoAction).setAuthoritative(Boolean.valueOf(true)).setEid(eid).setLocatorRecord(locators).setMapVersion(Short.valueOf((short)0)).setRecordTtl(Integer.valueOf(1440));
        AddMappingInputBuilder mib = new AddMappingInputBuilder();
        mib.setMappingRecord(mrb.build());
        return mib.build();
    }

    public static AddKeyInput buildAddKeyInput(Eid eid, String net) {
        AddKeyInputBuilder kib = new AddKeyInputBuilder();
        kib.setEid(eid).setMappingAuthkey(new MappingAuthkeyBuilder().setKeyString(net).setKeyType(Uint16.ONE).build());
        return kib.build();
    }

    public static GetMappingInput buildGetMappingInput(Eid eid) {
        return new GetMappingInputBuilder().setEid(eid).build();
    }

    public static RemoveMappingInput buildRemoveMappingInput(Eid eid) {
        RemoveMappingInputBuilder rmib = new RemoveMappingInputBuilder();
        rmib.setEid(eid);
        return rmib.build();
    }

    public static RemoveKeyInput buildRemoveKeyInput(Eid eid) {
        RemoveKeyInputBuilder kib = new RemoveKeyInputBuilder();
        kib.setEid(eid);
        return kib.build();
    }
}

