/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.lispflowmapping.neutron.DataProcessor;
import org.opendaylight.lispflowmapping.neutron.ILispNeutronService;
import org.opendaylight.lispflowmapping.neutron.LispUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.AddKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.OdlMappingserviceService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.subnets.rev150712.subnets.attributes.subnets.Subnet;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SubnetDataProcessor
implements DataProcessor<Subnet> {
    private static final Logger LOG = LoggerFactory.getLogger(SubnetDataProcessor.class);
    private volatile ILispNeutronService lispNeutronService;

    public SubnetDataProcessor(ILispNeutronService lispNeutronService) {
        this.lispNeutronService = lispNeutronService;
    }

    @Override
    public void create(Subnet subnet) {
        LOG.info("Neutron Subnet Created request : Subnet name: " + subnet.getName() + " Subnet Cidr: " + subnet.getCidr());
        LOG.debug("Lisp Neutron Subnet: " + subnet.toString());
        Eid eid = LispAddressUtil.asIpv4PrefixEid((String)subnet.getCidr().stringValue());
        try {
            OdlMappingserviceService lfmdb = this.lispNeutronService.getMappingDbService();
            if (lfmdb == null) {
                LOG.debug("lfmdb is null!!!");
                return;
            }
            AddKeyInput addKeyInput = LispUtil.buildAddKeyInput(eid, subnet.getUuid().getValue());
            ListenableFuture result = lfmdb.addKey(addKeyInput);
            Boolean isSuccessful = ((RpcResult)result.get()).isSuccessful();
            if (isSuccessful.booleanValue()) {
                LOG.debug("Neutron Subnet Added to MapServer : Subnet name: " + subnet.getName() + " EID Prefix: " + subnet.getCidr() + " Key: " + subnet.getUuid());
            }
            LOG.info("Neutron Subnet Created request : Subnet name: " + subnet.getName() + " Subnet Cidr: " + subnet.getCidr());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Adding new subnet to lisp service mapping service failed. Subnet : " + subnet.toString() + "Error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void update(Subnet subnet) {
    }

    @Override
    public void delete(Subnet subnet) {
        LOG.info("Neutron Subnet Deleted Request : Subnet name: " + subnet.getName() + " Subnet Cidr: " + subnet.getCidr() + "Key: " + subnet.getUuid());
        LOG.debug("Lisp Neutron Subnet: " + subnet.toString());
        Eid eid = LispAddressUtil.asIpv4PrefixEid((String)subnet.getCidr().stringValue());
        try {
            OdlMappingserviceService lfmdb = this.lispNeutronService.getMappingDbService();
            if (lfmdb == null) {
                LOG.debug("lfmdb is null!!!");
                return;
            }
            RemoveKeyInput removeKeyInput = LispUtil.buildRemoveKeyInput(eid);
            ListenableFuture result = lfmdb.removeKey(removeKeyInput);
            Boolean isSuccessful = ((RpcResult)result.get()).isSuccessful();
            if (isSuccessful.booleanValue()) {
                LOG.debug("Neutron Subnet Deleted from MapServer : Subnet name: " + subnet.getName() + " Eid Prefix: " + subnet.getCidr() + " Key: " + subnet.getUuid());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Deleting subnet's EID prefix from mapping service failed + Subnet: " + subnet.toString() + "Error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

