/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler;

import org.opendaylight.lispflowmapping.neutron.intenthandler.IntentHandlerAsyncExecutorProvider;
import org.opendaylight.lispflowmapping.neutron.intenthandler.listener.service.VbridgeTopologyListenerService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupBasedPolicyNeutronIntentHandlerBean
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GroupBasedPolicyNeutronIntentHandlerBean.class);
    private final DataBroker dataBroker;
    private final MountPointService mountService;
    private VbridgeTopologyListenerService vbridgeTopologyListenerService;
    private final IntentHandlerAsyncExecutorProvider intentHandlerAsyncExecutorProvider = IntentHandlerAsyncExecutorProvider.getInstace();

    public GroupBasedPolicyNeutronIntentHandlerBean(DataBroker dataBroker, MountPointService mountService) {
        this.dataBroker = dataBroker;
        this.mountService = mountService;
    }

    @Override
    public void close() throws Exception {
        LOG.info("Clustering provider closed for {}", (Object)this.getClass().getSimpleName());
        this.intentHandlerAsyncExecutorProvider.close();
    }

    public void init() {
        LOG.info("LFM neutron handler service registered", (Object)this.getClass().getSimpleName());
        this.vbridgeTopologyListenerService = VbridgeTopologyListenerService.initialize(this.dataBroker, this.mountService);
    }
}

