/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.listener;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.lispflowmapping.neutron.intenthandler.IntentHandlerAsyncExecutorProvider;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.VppNetconfConnectionProbe;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.VppNodeReader;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.HostInformationManager;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VppEndpointListener
implements AutoCloseable,
ClusteredDataTreeChangeListener<Topology> {
    private static final Logger LOG = LoggerFactory.getLogger(VppEndpointListener.class);
    private final DataBroker dataBroker;
    private final MountPointService mountService;
    private final ListenerRegistration<?> reg;
    private final VppNodeReader vppNodeReader;
    private final HostInformationManager hostInformationManager;
    private final Multimap<NodeId, KeyedInstanceIdentifier<Node, NodeKey>> nodeIdToKeyedInstanceIdentifierMap = ArrayListMultimap.create();
    private final ListeningExecutorService executorService;

    public VppEndpointListener(DataBroker dataBroker, MountPointService mountPointService, KeyedInstanceIdentifier<Topology, TopologyKey> topologyII) {
        this.dataBroker = dataBroker;
        this.mountService = mountPointService;
        this.vppNodeReader = new VppNodeReader(this.dataBroker, this.mountService);
        this.hostInformationManager = HostInformationManager.getInstance();
        this.reg = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, topologyII), (DataTreeChangeListener)this);
        this.executorService = IntentHandlerAsyncExecutorProvider.getInstace().getExecutor();
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Topology>> changes) {
        for (DataTreeModification<Topology> change : changes) {
            ListenableFuture modificationTaskHandler;
            DataObjectModification modification = change.getRootNode();
            switch (modification.getModificationType()) {
                case WRITE: {
                    modificationTaskHandler = this.handleChange(modification);
                    break;
                }
                case SUBTREE_MODIFIED: {
                    modificationTaskHandler = this.handleChange(modification);
                    break;
                }
                case DELETE: {
                    modificationTaskHandler = this.handleDeleteOnTopology();
                    break;
                }
                default: {
                    LOG.warn("Ignored topology modification {}", (Object)modification);
                    modificationTaskHandler = Futures.immediateFuture(null);
                }
            }
            Futures.addCallback((ListenableFuture)modificationTaskHandler, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(Void vd) {
                    LOG.debug("VppEndpoint modification handled successfully!");
                }

                public void onFailure(Throwable throwable) {
                    LOG.debug("Failed to handle VppEndpoint modifications!");
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private ListenableFuture<Void> handleChange(DataObjectModification modification) {
        Collection modifiedChildren = modification.getModifiedChildren();
        ArrayList<ListenableFuture<KeyedInstanceIdentifier<Node, NodeKey>>> processingTasks = new ArrayList<ListenableFuture<KeyedInstanceIdentifier<Node, NodeKey>>>();
        for (DataObjectModification modifiedNode : modifiedChildren) {
            final Node newOrModifiedNode = (Node)modifiedNode.getDataAfter();
            ListenableFuture<KeyedInstanceIdentifier<Node, NodeKey>> processingTask = this.processNode(newOrModifiedNode);
            Futures.addCallback(processingTask, (FutureCallback)new FutureCallback<KeyedInstanceIdentifier<Node, NodeKey>>(){

                public void onSuccess(KeyedInstanceIdentifier<Node, NodeKey> kiiToNode) {
                    VppEndpointListener.this.hostInformationManager.addHostRelatedInfo(newOrModifiedNode.getNodeId().getValue(), LispAddressUtil.toRloc((Ipv4Address)VppEndpointListener.this.vppNodeReader.rlocIpOfNode(kiiToNode)));
                }

                public void onFailure(Throwable throwable) {
                    LOG.debug("Couldn't process {}", (Object)newOrModifiedNode.getNodeId().getValue());
                }
            }, (Executor)MoreExecutors.directExecutor());
            processingTasks.add(this.processNode(newOrModifiedNode));
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<KeyedInstanceIdentifier<Node, NodeKey>> processNode(Node newOrModifiedNode) {
        ListenableFuture probeVppNodeForConnection = this.executorService.submit(() -> {
            this.processNodeOnConnection(newOrModifiedNode);
            return null;
        });
        return Futures.transform((ListenableFuture)probeVppNodeForConnection, vd -> (KeyedInstanceIdentifier)this.nodeIdToKeyedInstanceIdentifierMap.get((Object)newOrModifiedNode.getNodeId()).iterator().next(), (Executor)MoreExecutors.directExecutor());
    }

    private void processNodeOnConnection(Node newOrModifiedNode) {
        for (SupportingNode supportingNode : newOrModifiedNode.nonnullSupportingNode().values()) {
            NodeId nodeMount = supportingNode.getNodeRef();
            VppNetconfConnectionProbe probe = new VppNetconfConnectionProbe(supportingNode.getNodeRef(), this.dataBroker);
            try {
                boolean connectionReady = probe.startProbing();
                if (connectionReady) {
                    LOG.debug("Node {} is connected, creating ...", (Object)supportingNode.getNodeRef());
                    TopologyId topologyMount = supportingNode.getTopologyRef();
                    KeyedInstanceIdentifier iiToVpp = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(topologyMount)).child(Node.class, (Identifier)new NodeKey(nodeMount));
                    this.nodeIdToKeyedInstanceIdentifierMap.put((Object)newOrModifiedNode.getNodeId(), (Object)iiToVpp);
                    continue;
                }
                LOG.debug("Failed while connecting to node {}", (Object)supportingNode.getNodeRef());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception while processing node {} ... ", (Object)supportingNode.getNodeRef(), (Object)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Node {} was not connected within {} seconds. Check node configuration and connectivity to proceed", (Object)supportingNode.getNodeRef(), (Object)60);
            }
        }
    }

    private ListenableFuture<Void> handleDeleteOnTopology() {
        return Futures.immediateFuture(null);
    }

    @Override
    public void close() {
        this.reg.close();
    }
}

