/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.listener.service;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.lispflowmapping.neutron.intenthandler.listener.VbridgeTopologyListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.TopologyTypesVbridgeAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.topology.types.VbridgeTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbridgeTopologyListenerService
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VbridgeTopologyListenerService.class);
    private final ListenerRegistration<VbridgeTopologyListener> listenerRegistration;
    private boolean closed;
    private static final DataTreeIdentifier<VbridgeTopology> TREE_LISTENER_IDENTIFIER = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class).child(TopologyTypes.class).augmentation(TopologyTypesVbridgeAugment.class).child(VbridgeTopology.class).build());

    public VbridgeTopologyListenerService(ListenerRegistration<VbridgeTopologyListener> reg) {
        this.listenerRegistration = reg;
        this.closed = false;
    }

    public static VbridgeTopologyListenerService initialize(@NonNull DataBroker dataBroker, @NonNull MountPointService mountPointService) {
        ListenerRegistration reg = dataBroker.registerDataTreeChangeListener(TREE_LISTENER_IDENTIFIER, (DataTreeChangeListener)new VbridgeTopologyListener(dataBroker, mountPointService));
        return new VbridgeTopologyListenerService((ListenerRegistration<VbridgeTopologyListener>)reg);
    }

    @Override
    public void close() {
        if (!this.closed) {
            VbridgeTopologyListener listener = (VbridgeTopologyListener)this.listenerRegistration.getInstance();
            this.listenerRegistration.close();
            listener.close();
            this.closed = true;
        }
    }
}

