/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.util;

import java.util.Optional;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.MountPoint;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LispNeutronUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(LispNeutronUtil.class);

    private LispNeutronUtil() {
    }

    public static DataBroker resolveDataBrokerForMountPoint(InstanceIdentifier<Node> iiToMountPoint, MountPointService mountService) {
        MountPoint vppMountPoint;
        Optional dataBrokerOpt;
        Optional vppMountPointOpt = mountService.getMountPoint(iiToMountPoint);
        if (vppMountPointOpt.isPresent() && (dataBrokerOpt = (vppMountPoint = (MountPoint)vppMountPointOpt.get()).getService(DataBroker.class)).isPresent()) {
            return (DataBroker)dataBrokerOpt.get();
        }
        return null;
    }
}

