/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.util;

import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.VppNodeReader;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VppNetconfConnectionProbe
implements ClusteredDataTreeChangeListener<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(VppNodeReader.class);
    public static final int NODE_CONNECTION_TIMER = 60;
    private final DataBroker dataBroker;
    private ListenerRegistration<VppNetconfConnectionProbe> registeredListener;
    private final SettableFuture<Boolean> connectionStatusFuture = SettableFuture.create();
    private static final String TOPOLOGY_IDENTIFIER = "topology-netconf";
    private final DataTreeIdentifier<Node> path;

    public VppNetconfConnectionProbe(NodeId nodeId, DataBroker dataBroker) {
        this.dataBroker = dataBroker;
        InstanceIdentifier nodeIid = InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(TOPOLOGY_IDENTIFIER))).child(Node.class, (Identifier)new NodeKey(nodeId)).build();
        this.path = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)nodeIid);
    }

    public boolean startProbing() throws ExecutionException, InterruptedException, TimeoutException {
        this.registeredListener = this.dataBroker.registerDataTreeChangeListener(this.path, (DataTreeChangeListener)this);
        return (Boolean)this.connectionStatusFuture.get(60L, TimeUnit.SECONDS);
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Node>> changes) {
        changes.forEach(modification -> {
            DataObjectModification rootNode = modification.getRootNode();
            Node node = (Node)rootNode.getDataAfter();
            NetconfNode netconfNode = this.getNodeAugmentation(node);
            if (node == null || node.getNodeId() == null) {
                return;
            }
            if (netconfNode == null || netconfNode.getConnectionStatus() == null) {
                this.connectionStatusFuture.set((Object)false);
                this.unregister();
            } else {
                NetconfNodeConnectionStatus.ConnectionStatus status = netconfNode.getConnectionStatus();
                if (status.equals((Object)NetconfNodeConnectionStatus.ConnectionStatus.Connected)) {
                    this.connectionStatusFuture.set((Object)true);
                    this.unregister();
                } else if (!status.equals((Object)NetconfNodeConnectionStatus.ConnectionStatus.Connecting)) {
                    this.connectionStatusFuture.set((Object)false);
                    this.unregister();
                }
            }
        });
    }

    private NetconfNode getNodeAugmentation(Node node) {
        NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
        if (netconfNode == null) {
            return null;
        }
        return netconfNode;
    }

    private void unregister() {
        if (this.registeredListener != null) {
            this.registeredListener.close();
        }
    }
}

