/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.util;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VppNetconfTrasaction {
    private static final Logger LOG = LoggerFactory.getLogger(VppNetconfTrasaction.class);
    public static final byte RETRY_COUNT = 5;

    private VppNetconfTrasaction() {
    }

    public static synchronized <T extends DataObject> Optional<T> read(DataBroker dataBroker, LogicalDatastoreType datastoreType, InstanceIdentifier<T> instanceIdentifier) {
        LOG.trace("Started Netconf transaction on VPP Node");
        Objects.requireNonNull(dataBroker);
        for (int retryCounter = 5; retryCounter > 0; --retryCounter) {
            ReadTransaction readTransaction = dataBroker.newReadOnlyTransaction();
            try {
                Optional<T> returnData = VppNetconfTrasaction.readTransaction(instanceIdentifier, datastoreType, readTransaction);
                LOG.trace("Netconf READ transaction SUCCESSFUL. Data present: {}", (Object)returnData.isPresent());
                readTransaction.close();
                return returnData;
            }
            catch (IllegalStateException e) {
                LOG.warn("Assuming that netconf read-transaction failed, retrying. Retry Count: " + retryCounter, (Object)e.getMessage());
                readTransaction.close();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception while reading data. Retry Aborted.", (Object)e.getMessage());
                readTransaction.close();
                break;
            }
        }
        return Optional.empty();
    }

    private static <T extends DataObject> Optional<T> readTransaction(InstanceIdentifier<T> instanceIdentifier, LogicalDatastoreType datastoreType, ReadTransaction readTransaction) throws IllegalStateException, InterruptedException, ExecutionException {
        return (Optional)readTransaction.read(datastoreType, instanceIdentifier).get();
    }
}

