/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.mappingmanager;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.lispflowmapping.neutron.LispUtil;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.PortData;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers.HostIdToPortDataMapper;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers.HostIdToRlocMapper;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers.NeutronTenantToVniMapper;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers.PortUuidToPortDataMapper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.rloc.container.Rloc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.OdlMappingserviceService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.RemoveMappingInput;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostInformationManager {
    private static final Logger LOG = LoggerFactory.getLogger(HostInformationManager.class);
    private OdlMappingserviceService lfmDbService;
    private final HostIdToPortDataMapper hostIdToPortDataMapper = new HostIdToPortDataMapper();
    private final HostIdToRlocMapper hostIdToRlocMapper = new HostIdToRlocMapper();
    private final NeutronTenantToVniMapper neutronTenantToVniMapper = new NeutronTenantToVniMapper();
    private static HostInformationManager instance;

    HostInformationManager() {
    }

    public static synchronized HostInformationManager getInstance() {
        if (instance == null) {
            instance = new HostInformationManager();
        }
        return instance;
    }

    public @NonNull Uint32 getInstanceId(String tenantUuid) {
        return this.neutronTenantToVniMapper.getVni(tenantUuid);
    }

    public void setOdlMappingserviceService(OdlMappingserviceService mappingservice) {
        this.lfmDbService = mappingservice;
    }

    public synchronized void addHostRelatedInfo(String hostId, Object data) {
        if (data instanceof PortData) {
            this.attemptToDeleteMappingRecord(hostId, ((PortData)data).getPortUuid());
            this.hostIdToPortDataMapper.addMapping(hostId, (PortData)data);
        } else if (data instanceof Rloc) {
            this.hostIdToRlocMapper.addMapping(hostId, (Rloc)data);
        } else {
            LOG.warn("Unwanted information type " + data.getClass().getSimpleName() + " for Host Id " + hostId);
        }
        this.attemptToCreateMappingRecord(hostId);
    }

    private synchronized void attemptToCreateMappingRecord(String hostId) {
        List<Rloc> rlocForMappingRecord = this.hostIdToRlocMapper.getRlocs(hostId);
        PortUuidToPortDataMapper uuidToEidMapper = this.hostIdToPortDataMapper.getAllPortData(hostId);
        if (rlocForMappingRecord == null || rlocForMappingRecord.isEmpty() || uuidToEidMapper == null) {
            return;
        }
        Collection<PortData> allUnprocessedPorts = uuidToEidMapper.getAllUnprocessedPorts();
        List locators = LispAddressUtil.asLocatorRecords(rlocForMappingRecord);
        allUnprocessedPorts.forEach(portData -> {
            this.lfmDbService.addMapping(LispUtil.buildAddMappingInput(portData.getPortEid(), locators));
            uuidToEidMapper.addPortDataToProcessed((PortData)portData);
        });
        uuidToEidMapper.clearAllUnprocessedData();
    }

    private synchronized void attemptToDeleteMappingRecord(String hostId, String portUuid) {
        PortUuidToPortDataMapper uuidToEidMapper = this.hostIdToPortDataMapper.getAllPortData(hostId);
        if (uuidToEidMapper == null) {
            return;
        }
        PortData oldPortData = uuidToEidMapper.getProcessedPortData(portUuid);
        if (oldPortData == null) {
            return;
        }
        RemoveMappingInput removeMappingInput = LispUtil.buildRemoveMappingInput(oldPortData.getPortEid());
        this.lfmDbService.removeMapping(removeMappingInput);
        uuidToEidMapper.deleteProcessedPortData(portUuid);
    }
}

