/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers;

import java.util.Collection;
import java.util.HashMap;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.PortData;

public class PortUuidToPortDataMapper {
    private HashMap<String, PortData> unprocessedPortUuidToEidMapper = new HashMap();
    private HashMap<String, PortData> processedPortUuidToEidMapper = new HashMap();

    public synchronized void addUnprocessedUuidToPortDataMapping(String uuid, PortData portData) {
        this.unprocessedPortUuidToEidMapper.put(uuid, portData);
    }

    public synchronized void addPortDataToProcessed(PortData portData) {
        this.processedPortUuidToEidMapper.put(portData.getPortUuid(), portData);
    }

    public synchronized PortData getProcessedPortData(String uuid) {
        return this.processedPortUuidToEidMapper.get(uuid);
    }

    public synchronized void deleteProcessedPortData(String portUuid) {
        this.processedPortUuidToEidMapper.remove(portUuid);
    }

    public synchronized void delereUnprocessedPortData(String portUuid) {
        this.unprocessedPortUuidToEidMapper.remove(portUuid);
    }

    public synchronized Collection<PortData> getAllUnprocessedPorts() {
        return this.unprocessedPortUuidToEidMapper.values();
    }

    public synchronized void clearAllUnprocessedData() {
        this.unprocessedPortUuidToEidMapper.clear();
    }

    public synchronized void clearAllProcessedData() {
        this.processedPortUuidToEidMapper.clear();
    }

    public synchronized void clearAllData() {
        this.clearAllProcessedData();
        this.clearAllUnprocessedData();
    }

    public synchronized void transferAllProcessedPortDataToUnprocessed() {
        this.processedPortUuidToEidMapper.forEach(this.unprocessedPortUuidToEidMapper::putIfAbsent);
        this.processedPortUuidToEidMapper.clear();
    }
}

