/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceNameOrIndex;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStateChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStatus;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class InterfaceStateChangeBuilder
implements Builder<InterfaceStateChange> {
    private InterfaceStatus _adminStatus;
    private InterfaceNameOrIndex _name;
    private InterfaceStatus _operStatus;
    Map<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>> augmentation = Collections.emptyMap();

    public InterfaceStateChangeBuilder() {
    }

    public InterfaceStateChangeBuilder(InterfaceStateChange base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>(aug);
        }
        this._adminStatus = base.getAdminStatus();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
    }

    public InterfaceStatus getAdminStatus() {
        return this._adminStatus;
    }

    public InterfaceNameOrIndex getName() {
        return this._name;
    }

    public InterfaceStatus getOperStatus() {
        return this._operStatus;
    }

    public <E$$ extends Augmentation<InterfaceStateChange>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public InterfaceStateChangeBuilder setAdminStatus(InterfaceStatus value) {
        this._adminStatus = value;
        return this;
    }

    public InterfaceStateChangeBuilder setName(InterfaceNameOrIndex value) {
        this._name = value;
        return this;
    }

    public InterfaceStateChangeBuilder setOperStatus(InterfaceStatus value) {
        this._operStatus = value;
        return this;
    }

    public InterfaceStateChangeBuilder addAugmentation(Augmentation<InterfaceStateChange> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceStateChange>>, Augmentation<InterfaceStateChange>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InterfaceStateChangeBuilder removeAugmentation(Class<? extends Augmentation<InterfaceStateChange>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceStateChange build() {
        return new InterfaceStateChangeImpl(this);
    }

    private static final class InterfaceStateChangeImpl
    extends AbstractAugmentable<InterfaceStateChange>
    implements InterfaceStateChange {
        private final InterfaceStatus _adminStatus;
        private final InterfaceNameOrIndex _name;
        private final InterfaceStatus _operStatus;
        private int hash = 0;
        private volatile boolean hashValid = false;

        InterfaceStateChangeImpl(InterfaceStateChangeBuilder base) {
            super(base.augmentation);
            this._adminStatus = base.getAdminStatus();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
        }

        @Override
        public InterfaceStatus getAdminStatus() {
            return this._adminStatus;
        }

        @Override
        public InterfaceNameOrIndex getName() {
            return this._name;
        }

        @Override
        public InterfaceStatus getOperStatus() {
            return this._operStatus;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = InterfaceStateChange.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return InterfaceStateChange.bindingEquals(this, obj);
        }

        public String toString() {
            return InterfaceStateChange.bindingToString(this);
        }
    }
}

