/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class VxlanVni
implements ScalarTypeObject<Uint32>,
Serializable {
    private static final long serialVersionUID = -1581787068544346330L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..16777215]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public VxlanVni(Uint32 _value) {
        if (_value != null) {
            VxlanVni.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    @Deprecated(forRemoval=true)
    public VxlanVni(Long _value) {
        this(CodeHelpers.compatUint((Long)_value));
    }

    public VxlanVni(VxlanVni source) {
        this._value = source._value;
    }

    public static VxlanVni getDefaultInstance(String defaultValue) {
        return new VxlanVni(Uint32.valueOf((String)defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VxlanVni)) {
            return false;
        }
        VxlanVni other = (VxlanVni)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(VxlanVni.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

