/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.BridgeDomain;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.BridgeDomainKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeDomainBuilder
implements Builder<BridgeDomain> {
    private Boolean _arpTermination;
    private ArpTerminationTable _arpTerminationTable;
    private Boolean _flood;
    private Boolean _forward;
    private L2FibTable _l2FibTable;
    private Boolean _learn;
    private String _name;
    private Boolean _unknownUnicastFlood;
    private BridgeDomainKey key;
    Map<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>> augmentation = Collections.emptyMap();

    public BridgeDomainBuilder() {
    }

    public BridgeDomainBuilder(BridgeDomainAttributes arg) {
        this._flood = arg.getFlood();
        this._forward = arg.getForward();
        this._learn = arg.getLearn();
        this._unknownUnicastFlood = arg.getUnknownUnicastFlood();
        this._arpTermination = arg.getArpTermination();
        this._arpTerminationTable = arg.getArpTerminationTable();
    }

    public BridgeDomainBuilder(L2FibAttributes arg) {
        this._l2FibTable = arg.getL2FibTable();
    }

    public BridgeDomainBuilder(BridgeDomain base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._arpTermination = base.getArpTermination();
        this._arpTerminationTable = base.getArpTerminationTable();
        this._flood = base.getFlood();
        this._forward = base.getForward();
        this._l2FibTable = base.getL2FibTable();
        this._learn = base.getLearn();
        this._unknownUnicastFlood = base.getUnknownUnicastFlood();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BridgeDomainAttributes) {
            this._flood = ((BridgeDomainAttributes)arg).getFlood();
            this._forward = ((BridgeDomainAttributes)arg).getForward();
            this._learn = ((BridgeDomainAttributes)arg).getLearn();
            this._unknownUnicastFlood = ((BridgeDomainAttributes)arg).getUnknownUnicastFlood();
            this._arpTermination = ((BridgeDomainAttributes)arg).getArpTermination();
            this._arpTerminationTable = ((BridgeDomainAttributes)arg).getArpTerminationTable();
            isValidArg = true;
        }
        if (arg instanceof L2FibAttributes) {
            this._l2FibTable = ((L2FibAttributes)arg).getL2FibTable();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes]");
    }

    public BridgeDomainKey key() {
        return this.key;
    }

    public Boolean getArpTermination() {
        return this._arpTermination;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isArpTermination() {
        return this.getArpTermination();
    }

    public ArpTerminationTable getArpTerminationTable() {
        return this._arpTerminationTable;
    }

    public Boolean getFlood() {
        return this._flood;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isFlood() {
        return this.getFlood();
    }

    public Boolean getForward() {
        return this._forward;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isForward() {
        return this.getForward();
    }

    public L2FibTable getL2FibTable() {
        return this._l2FibTable;
    }

    public Boolean getLearn() {
        return this._learn;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isLearn() {
        return this.getLearn();
    }

    public String getName() {
        return this._name;
    }

    public Boolean getUnknownUnicastFlood() {
        return this._unknownUnicastFlood;
    }

    @Deprecated(forRemoval=true)
    public final Boolean isUnknownUnicastFlood() {
        return this.getUnknownUnicastFlood();
    }

    public <E$$ extends Augmentation<BridgeDomain>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BridgeDomainBuilder withKey(BridgeDomainKey key) {
        this.key = key;
        return this;
    }

    public BridgeDomainBuilder setArpTermination(Boolean value) {
        this._arpTermination = value;
        return this;
    }

    public BridgeDomainBuilder setArpTerminationTable(ArpTerminationTable value) {
        this._arpTerminationTable = value;
        return this;
    }

    public BridgeDomainBuilder setFlood(Boolean value) {
        this._flood = value;
        return this;
    }

    public BridgeDomainBuilder setForward(Boolean value) {
        this._forward = value;
        return this;
    }

    public BridgeDomainBuilder setL2FibTable(L2FibTable value) {
        this._l2FibTable = value;
        return this;
    }

    public BridgeDomainBuilder setLearn(Boolean value) {
        this._learn = value;
        return this;
    }

    public BridgeDomainBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public BridgeDomainBuilder setUnknownUnicastFlood(Boolean value) {
        this._unknownUnicastFlood = value;
        return this;
    }

    public BridgeDomainBuilder addAugmentation(Augmentation<BridgeDomain> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BridgeDomain>>, Augmentation<BridgeDomain>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BridgeDomainBuilder removeAugmentation(Class<? extends Augmentation<BridgeDomain>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BridgeDomain build() {
        return new BridgeDomainImpl(this);
    }

    private static final class BridgeDomainImpl
    extends AbstractAugmentable<BridgeDomain>
    implements BridgeDomain {
        private final Boolean _arpTermination;
        private final ArpTerminationTable _arpTerminationTable;
        private final Boolean _flood;
        private final Boolean _forward;
        private final L2FibTable _l2FibTable;
        private final Boolean _learn;
        private final String _name;
        private final Boolean _unknownUnicastFlood;
        private final BridgeDomainKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BridgeDomainImpl(BridgeDomainBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new BridgeDomainKey(base.getName());
            this._name = this.key.getName();
            this._arpTermination = base.getArpTermination();
            this._arpTerminationTable = base.getArpTerminationTable();
            this._flood = base.getFlood();
            this._forward = base.getForward();
            this._l2FibTable = base.getL2FibTable();
            this._learn = base.getLearn();
            this._unknownUnicastFlood = base.getUnknownUnicastFlood();
        }

        @Override
        public BridgeDomainKey key() {
            return this.key;
        }

        @Override
        public Boolean getArpTermination() {
            return this._arpTermination;
        }

        @Override
        public ArpTerminationTable getArpTerminationTable() {
            return this._arpTerminationTable;
        }

        @Override
        public Boolean getFlood() {
            return this._flood;
        }

        @Override
        public Boolean getForward() {
            return this._forward;
        }

        @Override
        public L2FibTable getL2FibTable() {
            return this._l2FibTable;
        }

        @Override
        public Boolean getLearn() {
            return this._learn;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Boolean getUnknownUnicastFlood() {
            return this._unknownUnicastFlood;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = BridgeDomain.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return BridgeDomain.bindingEquals(this, obj);
        }

        public String toString() {
            return BridgeDomain.bindingToString(this);
        }
    }
}

