/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.EthernetBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface.Ethernet;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class EthernetBuilder
implements Builder<Ethernet> {
    private Uint16 _mtu;
    Map<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>> augmentation = Collections.emptyMap();

    public EthernetBuilder() {
    }

    public EthernetBuilder(EthernetBaseAttributes arg) {
        this._mtu = arg.getMtu();
    }

    public EthernetBuilder(Ethernet base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>(aug);
        }
        this._mtu = base.getMtu();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetBaseAttributes) {
            this._mtu = ((EthernetBaseAttributes)arg).getMtu();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.EthernetBaseAttributes]");
    }

    public Uint16 getMtu() {
        return this._mtu;
    }

    public <E$$ extends Augmentation<Ethernet>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkMtuRange(int value) {
        if (value >= 64 && value <= 9216) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[64..9216]]", (int)value);
    }

    public EthernetBuilder setMtu(Uint16 value) {
        if (value != null) {
            EthernetBuilder.checkMtuRange(value.intValue());
        }
        this._mtu = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public EthernetBuilder setMtu(Integer value) {
        return this.setMtu(CodeHelpers.compatUint((Integer)value));
    }

    public EthernetBuilder addAugmentation(Augmentation<Ethernet> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ethernet>>, Augmentation<Ethernet>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EthernetBuilder removeAugmentation(Class<? extends Augmentation<Ethernet>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ethernet build() {
        return new EthernetImpl(this);
    }

    private static final class EthernetImpl
    extends AbstractAugmentable<Ethernet>
    implements Ethernet {
        private final Uint16 _mtu;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EthernetImpl(EthernetBuilder base) {
            super(base.augmentation);
            this._mtu = base.getMtu();
        }

        @Override
        public Uint16 getMtu() {
            return this._mtu;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Ethernet.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Ethernet.bindingEquals(this, obj);
        }

        public String toString() {
            return Ethernet.bindingToString(this);
        }
    }
}

