/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceConfigAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface.VhostUser;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class VhostUserBuilder
implements Builder<VhostUser> {
    private Uint32 _deviceInstance;
    private VhostUserRole _role;
    private String _socket;
    private String _tag;
    Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> augmentation = Collections.emptyMap();

    public VhostUserBuilder() {
    }

    public VhostUserBuilder(VhostUserInterfaceBaseAttributes arg) {
        this._socket = arg.getSocket();
        this._role = arg.getRole();
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(InterfaceTag arg) {
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(VhostUserInterfaceConfigAttributes arg) {
        this._deviceInstance = arg.getDeviceInstance();
    }

    public VhostUserBuilder(VhostUser base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>(aug);
        }
        this._deviceInstance = base.getDeviceInstance();
        this._role = base.getRole();
        this._socket = base.getSocket();
        this._tag = base.getTag();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VhostUserInterfaceBaseAttributes) {
            this._socket = ((VhostUserInterfaceBaseAttributes)arg).getSocket();
            this._role = ((VhostUserInterfaceBaseAttributes)arg).getRole();
            isValidArg = true;
        }
        if (arg instanceof InterfaceTag) {
            this._tag = ((InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        if (arg instanceof VhostUserInterfaceConfigAttributes) {
            this._deviceInstance = ((VhostUserInterfaceConfigAttributes)arg).getDeviceInstance();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceConfigAttributes]");
    }

    public Uint32 getDeviceInstance() {
        return this._deviceInstance;
    }

    public VhostUserRole getRole() {
        return this._role;
    }

    public String getSocket() {
        return this._socket;
    }

    public String getTag() {
        return this._tag;
    }

    public <E$$ extends Augmentation<VhostUser>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VhostUserBuilder setDeviceInstance(Uint32 value) {
        this._deviceInstance = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VhostUserBuilder setDeviceInstance(Long value) {
        return this.setDeviceInstance(CodeHelpers.compatUint((Long)value));
    }

    public VhostUserBuilder setRole(VhostUserRole value) {
        this._role = value;
        return this;
    }

    private static void check_socketLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 255) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..255]]", (Object)value);
    }

    public VhostUserBuilder setSocket(String value) {
        if (value != null) {
            VhostUserBuilder.check_socketLength(value);
        }
        this._socket = value;
        return this;
    }

    private static void check_tagLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 63) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..63]]", (Object)value);
    }

    public VhostUserBuilder setTag(String value) {
        if (value != null) {
            VhostUserBuilder.check_tagLength(value);
        }
        this._tag = value;
        return this;
    }

    public VhostUserBuilder addAugmentation(Augmentation<VhostUser> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VhostUserBuilder removeAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VhostUser build() {
        return new VhostUserImpl(this);
    }

    private static final class VhostUserImpl
    extends AbstractAugmentable<VhostUser>
    implements VhostUser {
        private final Uint32 _deviceInstance;
        private final VhostUserRole _role;
        private final String _socket;
        private final String _tag;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VhostUserImpl(VhostUserBuilder base) {
            super(base.augmentation);
            this._deviceInstance = base.getDeviceInstance();
            this._role = base.getRole();
            this._socket = base.getSocket();
            this._tag = base.getTag();
        }

        @Override
        public Uint32 getDeviceInstance() {
            return this._deviceInstance;
        }

        @Override
        public VhostUserRole getRole() {
            return this._role;
        }

        @Override
        public String getSocket() {
            return this._socket;
        }

        @Override
        public String getTag() {
            return this._tag;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = VhostUser.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return VhostUser.bindingEquals(this, obj);
        }

        public String toString() {
            return VhostUser.bindingToString(this);
        }
    }
}

