/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.DecapNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanVni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces._interface.Vxlan;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class VxlanBuilder
implements Builder<Vxlan> {
    private Class<? extends DecapNode> _decapNext;
    private IpAddress _dst;
    private Uint32 _encapVrfId;
    private IpAddress _src;
    private VxlanVni _vni;
    Map<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>> augmentation = Collections.emptyMap();

    public VxlanBuilder() {
    }

    public VxlanBuilder(VxlanBaseAttributes arg) {
        this._src = arg.getSrc();
        this._dst = arg.getDst();
        this._vni = arg.getVni();
        this._encapVrfId = arg.getEncapVrfId();
        this._decapNext = arg.getDecapNext();
    }

    public VxlanBuilder(Vxlan base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>(aug);
        }
        this._decapNext = base.getDecapNext();
        this._dst = base.getDst();
        this._encapVrfId = base.getEncapVrfId();
        this._src = base.getSrc();
        this._vni = base.getVni();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VxlanBaseAttributes) {
            this._src = ((VxlanBaseAttributes)arg).getSrc();
            this._dst = ((VxlanBaseAttributes)arg).getDst();
            this._vni = ((VxlanBaseAttributes)arg).getVni();
            this._encapVrfId = ((VxlanBaseAttributes)arg).getEncapVrfId();
            this._decapNext = ((VxlanBaseAttributes)arg).getDecapNext();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanBaseAttributes]");
    }

    public Class<? extends DecapNode> getDecapNext() {
        return this._decapNext;
    }

    public IpAddress getDst() {
        return this._dst;
    }

    public Uint32 getEncapVrfId() {
        return this._encapVrfId;
    }

    public IpAddress getSrc() {
        return this._src;
    }

    public VxlanVni getVni() {
        return this._vni;
    }

    public <E$$ extends Augmentation<Vxlan>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VxlanBuilder setDecapNext(Class<? extends DecapNode> value) {
        this._decapNext = value;
        return this;
    }

    public VxlanBuilder setDst(IpAddress value) {
        this._dst = value;
        return this;
    }

    public VxlanBuilder setEncapVrfId(Uint32 value) {
        this._encapVrfId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VxlanBuilder setEncapVrfId(Long value) {
        return this.setEncapVrfId(CodeHelpers.compatUint((Long)value));
    }

    public VxlanBuilder setSrc(IpAddress value) {
        this._src = value;
        return this;
    }

    public VxlanBuilder setVni(VxlanVni value) {
        this._vni = value;
        return this;
    }

    public VxlanBuilder addAugmentation(Augmentation<Vxlan> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vxlan>>, Augmentation<Vxlan>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VxlanBuilder removeAugmentation(Class<? extends Augmentation<Vxlan>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Vxlan build() {
        return new VxlanImpl(this);
    }

    private static final class VxlanImpl
    extends AbstractAugmentable<Vxlan>
    implements Vxlan {
        private final Class<? extends DecapNode> _decapNext;
        private final IpAddress _dst;
        private final Uint32 _encapVrfId;
        private final IpAddress _src;
        private final VxlanVni _vni;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VxlanImpl(VxlanBuilder base) {
            super(base.augmentation);
            this._decapNext = base.getDecapNext();
            this._dst = base.getDst();
            this._encapVrfId = base.getEncapVrfId();
            this._src = base.getSrc();
            this._vni = base.getVni();
        }

        @Override
        public Class<? extends DecapNode> getDecapNext() {
            return this._decapNext;
        }

        @Override
        public IpAddress getDst() {
            return this._dst;
        }

        @Override
        public Uint32 getEncapVrfId() {
            return this._encapVrfId;
        }

        @Override
        public IpAddress getSrc() {
            return this._src;
        }

        @Override
        public VxlanVni getVni() {
            return this._vni;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Vxlan.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Vxlan.bindingEquals(this, obj);
        }

        public String toString() {
            return Vxlan.bindingToString(this);
        }
    }
}

