/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.TapInterfaceBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface.Tap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TapBuilder
implements Builder<Tap> {
    private String _tag;
    private String _tapName;
    Map<Class<? extends Augmentation<Tap>>, Augmentation<Tap>> augmentation = Collections.emptyMap();

    public TapBuilder() {
    }

    public TapBuilder(TapInterfaceBaseAttributes arg) {
        this._tapName = arg.getTapName();
        this._tag = arg.getTag();
    }

    public TapBuilder(InterfaceTag arg) {
        this._tag = arg.getTag();
    }

    public TapBuilder(Tap base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>(aug);
        }
        this._tag = base.getTag();
        this._tapName = base.getTapName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TapInterfaceBaseAttributes) {
            this._tapName = ((TapInterfaceBaseAttributes)arg).getTapName();
            isValidArg = true;
        }
        if (arg instanceof InterfaceTag) {
            this._tag = ((InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.TapInterfaceBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag]");
    }

    public String getTag() {
        return this._tag;
    }

    public String getTapName() {
        return this._tapName;
    }

    public <E$$ extends Augmentation<Tap>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void check_tagLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 63) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..63]]", (Object)value);
    }

    public TapBuilder setTag(String value) {
        if (value != null) {
            TapBuilder.check_tagLength(value);
        }
        this._tag = value;
        return this;
    }

    private static void check_tapNameLength(String value) {
    }

    public TapBuilder setTapName(String value) {
        if (value != null) {
            TapBuilder.check_tapNameLength(value);
        }
        this._tapName = value;
        return this;
    }

    public TapBuilder addAugmentation(Augmentation<Tap> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tap>>, Augmentation<Tap>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TapBuilder removeAugmentation(Class<? extends Augmentation<Tap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tap build() {
        return new TapImpl(this);
    }

    private static final class TapImpl
    extends AbstractAugmentable<Tap>
    implements Tap {
        private final String _tag;
        private final String _tapName;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TapImpl(TapBuilder base) {
            super(base.augmentation);
            this._tag = base.getTag();
            this._tapName = base.getTapName();
        }

        @Override
        public String getTag() {
            return this._tag;
        }

        @Override
        public String getTapName() {
            return this._tapName;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Tap.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Tap.bindingEquals(this, obj);
        }

        public String toString() {
            return Tap.bindingToString(this);
        }
    }
}

