/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface.VhostUser;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

public class VhostUserBuilder
implements Builder<VhostUser> {
    private String _connectError;
    private Uint64 _features;
    private Uint32 _numMemoryRegions;
    private VhostUserRole _role;
    private String _socket;
    private String _tag;
    private Uint32 _virtioNetHdrSize;
    Map<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>> augmentation = Collections.emptyMap();

    public VhostUserBuilder() {
    }

    public VhostUserBuilder(VhostUserInterfaceBaseAttributes arg) {
        this._socket = arg.getSocket();
        this._role = arg.getRole();
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(InterfaceTag arg) {
        this._tag = arg.getTag();
    }

    public VhostUserBuilder(VhostUserInterfaceStateAttributes arg) {
        this._features = arg.getFeatures();
        this._virtioNetHdrSize = arg.getVirtioNetHdrSize();
        this._numMemoryRegions = arg.getNumMemoryRegions();
        this._connectError = arg.getConnectError();
    }

    public VhostUserBuilder(VhostUser base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>(aug);
        }
        this._connectError = base.getConnectError();
        this._features = base.getFeatures();
        this._numMemoryRegions = base.getNumMemoryRegions();
        this._role = base.getRole();
        this._socket = base.getSocket();
        this._tag = base.getTag();
        this._virtioNetHdrSize = base.getVirtioNetHdrSize();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VhostUserInterfaceStateAttributes) {
            this._features = ((VhostUserInterfaceStateAttributes)arg).getFeatures();
            this._virtioNetHdrSize = ((VhostUserInterfaceStateAttributes)arg).getVirtioNetHdrSize();
            this._numMemoryRegions = ((VhostUserInterfaceStateAttributes)arg).getNumMemoryRegions();
            this._connectError = ((VhostUserInterfaceStateAttributes)arg).getConnectError();
            isValidArg = true;
        }
        if (arg instanceof VhostUserInterfaceBaseAttributes) {
            this._socket = ((VhostUserInterfaceBaseAttributes)arg).getSocket();
            this._role = ((VhostUserInterfaceBaseAttributes)arg).getRole();
            isValidArg = true;
        }
        if (arg instanceof InterfaceTag) {
            this._tag = ((InterfaceTag)arg).getTag();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceStateAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserInterfaceBaseAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceTag]");
    }

    public String getConnectError() {
        return this._connectError;
    }

    public Uint64 getFeatures() {
        return this._features;
    }

    public Uint32 getNumMemoryRegions() {
        return this._numMemoryRegions;
    }

    public VhostUserRole getRole() {
        return this._role;
    }

    public String getSocket() {
        return this._socket;
    }

    public String getTag() {
        return this._tag;
    }

    public Uint32 getVirtioNetHdrSize() {
        return this._virtioNetHdrSize;
    }

    public <E$$ extends Augmentation<VhostUser>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VhostUserBuilder setConnectError(String value) {
        this._connectError = value;
        return this;
    }

    public VhostUserBuilder setFeatures(Uint64 value) {
        this._features = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VhostUserBuilder setFeatures(BigInteger value) {
        return this.setFeatures(CodeHelpers.compatUint((BigInteger)value));
    }

    public VhostUserBuilder setNumMemoryRegions(Uint32 value) {
        this._numMemoryRegions = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VhostUserBuilder setNumMemoryRegions(Long value) {
        return this.setNumMemoryRegions(CodeHelpers.compatUint((Long)value));
    }

    public VhostUserBuilder setRole(VhostUserRole value) {
        this._role = value;
        return this;
    }

    private static void check_socketLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 255) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..255]]", (Object)value);
    }

    public VhostUserBuilder setSocket(String value) {
        if (value != null) {
            VhostUserBuilder.check_socketLength(value);
        }
        this._socket = value;
        return this;
    }

    private static void check_tagLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 63) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..63]]", (Object)value);
    }

    public VhostUserBuilder setTag(String value) {
        if (value != null) {
            VhostUserBuilder.check_tagLength(value);
        }
        this._tag = value;
        return this;
    }

    public VhostUserBuilder setVirtioNetHdrSize(Uint32 value) {
        this._virtioNetHdrSize = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VhostUserBuilder setVirtioNetHdrSize(Long value) {
        return this.setVirtioNetHdrSize(CodeHelpers.compatUint((Long)value));
    }

    public VhostUserBuilder addAugmentation(Augmentation<VhostUser> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VhostUser>>, Augmentation<VhostUser>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VhostUserBuilder removeAugmentation(Class<? extends Augmentation<VhostUser>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VhostUser build() {
        return new VhostUserImpl(this);
    }

    private static final class VhostUserImpl
    extends AbstractAugmentable<VhostUser>
    implements VhostUser {
        private final String _connectError;
        private final Uint64 _features;
        private final Uint32 _numMemoryRegions;
        private final VhostUserRole _role;
        private final String _socket;
        private final String _tag;
        private final Uint32 _virtioNetHdrSize;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VhostUserImpl(VhostUserBuilder base) {
            super(base.augmentation);
            this._connectError = base.getConnectError();
            this._features = base.getFeatures();
            this._numMemoryRegions = base.getNumMemoryRegions();
            this._role = base.getRole();
            this._socket = base.getSocket();
            this._tag = base.getTag();
            this._virtioNetHdrSize = base.getVirtioNetHdrSize();
        }

        @Override
        public String getConnectError() {
            return this._connectError;
        }

        @Override
        public Uint64 getFeatures() {
            return this._features;
        }

        @Override
        public Uint32 getNumMemoryRegions() {
            return this._numMemoryRegions;
        }

        @Override
        public VhostUserRole getRole() {
            return this._role;
        }

        @Override
        public String getSocket() {
            return this._socket;
        }

        @Override
        public String getTag() {
            return this._tag;
        }

        @Override
        public Uint32 getVirtioNetHdrSize() {
            return this._virtioNetHdrSize;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = VhostUser.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return VhostUser.bindingEquals(this, obj);
        }

        public String toString() {
            return VhostUser.bindingToString(this);
        }
    }
}

