/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeNextProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeVni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.interfaces.state._interface.VxlanGpe;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class VxlanGpeBuilder
implements Builder<VxlanGpe> {
    private Uint32 _decapVrfId;
    private Uint32 _encapVrfId;
    private IpAddress _local;
    private VxlanGpeNextProtocol _nextProtocol;
    private IpAddress _remote;
    private VxlanGpeVni _vni;
    Map<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>> augmentation = Collections.emptyMap();

    public VxlanGpeBuilder() {
    }

    public VxlanGpeBuilder(VxlanGpeBaseAttributes arg) {
        this._local = arg.getLocal();
        this._remote = arg.getRemote();
        this._vni = arg.getVni();
        this._nextProtocol = arg.getNextProtocol();
        this._encapVrfId = arg.getEncapVrfId();
        this._decapVrfId = arg.getDecapVrfId();
    }

    public VxlanGpeBuilder(VxlanGpe base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>(aug);
        }
        this._decapVrfId = base.getDecapVrfId();
        this._encapVrfId = base.getEncapVrfId();
        this._local = base.getLocal();
        this._nextProtocol = base.getNextProtocol();
        this._remote = base.getRemote();
        this._vni = base.getVni();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VxlanGpeBaseAttributes) {
            this._local = ((VxlanGpeBaseAttributes)arg).getLocal();
            this._remote = ((VxlanGpeBaseAttributes)arg).getRemote();
            this._vni = ((VxlanGpeBaseAttributes)arg).getVni();
            this._nextProtocol = ((VxlanGpeBaseAttributes)arg).getNextProtocol();
            this._encapVrfId = ((VxlanGpeBaseAttributes)arg).getEncapVrfId();
            this._decapVrfId = ((VxlanGpeBaseAttributes)arg).getDecapVrfId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeBaseAttributes]");
    }

    public Uint32 getDecapVrfId() {
        return this._decapVrfId;
    }

    public Uint32 getEncapVrfId() {
        return this._encapVrfId;
    }

    public IpAddress getLocal() {
        return this._local;
    }

    public VxlanGpeNextProtocol getNextProtocol() {
        return this._nextProtocol;
    }

    public IpAddress getRemote() {
        return this._remote;
    }

    public VxlanGpeVni getVni() {
        return this._vni;
    }

    public <E$$ extends Augmentation<VxlanGpe>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VxlanGpeBuilder setDecapVrfId(Uint32 value) {
        this._decapVrfId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VxlanGpeBuilder setDecapVrfId(Long value) {
        return this.setDecapVrfId(CodeHelpers.compatUint((Long)value));
    }

    public VxlanGpeBuilder setEncapVrfId(Uint32 value) {
        this._encapVrfId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public VxlanGpeBuilder setEncapVrfId(Long value) {
        return this.setEncapVrfId(CodeHelpers.compatUint((Long)value));
    }

    public VxlanGpeBuilder setLocal(IpAddress value) {
        this._local = value;
        return this;
    }

    public VxlanGpeBuilder setNextProtocol(VxlanGpeNextProtocol value) {
        this._nextProtocol = value;
        return this;
    }

    public VxlanGpeBuilder setRemote(IpAddress value) {
        this._remote = value;
        return this;
    }

    public VxlanGpeBuilder setVni(VxlanGpeVni value) {
        this._vni = value;
        return this;
    }

    public VxlanGpeBuilder addAugmentation(Augmentation<VxlanGpe> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VxlanGpe>>, Augmentation<VxlanGpe>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VxlanGpeBuilder removeAugmentation(Class<? extends Augmentation<VxlanGpe>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VxlanGpe build() {
        return new VxlanGpeImpl(this);
    }

    private static final class VxlanGpeImpl
    extends AbstractAugmentable<VxlanGpe>
    implements VxlanGpe {
        private final Uint32 _decapVrfId;
        private final Uint32 _encapVrfId;
        private final IpAddress _local;
        private final VxlanGpeNextProtocol _nextProtocol;
        private final IpAddress _remote;
        private final VxlanGpeVni _vni;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VxlanGpeImpl(VxlanGpeBuilder base) {
            super(base.augmentation);
            this._decapVrfId = base.getDecapVrfId();
            this._encapVrfId = base.getEncapVrfId();
            this._local = base.getLocal();
            this._nextProtocol = base.getNextProtocol();
            this._remote = base.getRemote();
            this._vni = base.getVni();
        }

        @Override
        public Uint32 getDecapVrfId() {
            return this._decapVrfId;
        }

        @Override
        public Uint32 getEncapVrfId() {
            return this._encapVrfId;
        }

        @Override
        public IpAddress getLocal() {
            return this._local;
        }

        @Override
        public VxlanGpeNextProtocol getNextProtocol() {
            return this._nextProtocol;
        }

        @Override
        public IpAddress getRemote() {
            return this._remote;
        }

        @Override
        public VxlanGpeVni getVni() {
            return this._vni;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = VxlanGpe.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return VxlanGpe.bindingEquals(this, obj);
        }

        public String toString() {
            return VxlanGpe.bindingToString(this);
        }
    }
}

