/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.lispflowmapping.neutron.DataProcessor;
import org.opendaylight.lispflowmapping.neutron.ILispNeutronService;
import org.opendaylight.lispflowmapping.neutron.NetworkDataProcessor;
import org.opendaylight.lispflowmapping.neutron.NetworkListener;
import org.opendaylight.lispflowmapping.neutron.PortDataProcessor;
import org.opendaylight.lispflowmapping.neutron.PortListener;
import org.opendaylight.lispflowmapping.neutron.SubnetDataProcessor;
import org.opendaylight.lispflowmapping.neutron.SubnetListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.networks.rev150712.networks.attributes.networks.Network;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.ports.rev150712.ports.attributes.ports.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.subnets.rev150712.subnets.attributes.subnets.Subnet;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingDataTreeListener<T extends DataObject>
implements ClusteredDataTreeChangeListener<T>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingDataTreeListener.class);
    private final DataProcessor<T> dataProcessor;
    private ListenerRegistration<ClusteredDataTreeChangeListener<T>> dataTreeChangeListenerRegistration;

    public DelegatingDataTreeListener(DataProcessor<T> dataProcessor, DataBroker dataBroker, DataTreeIdentifier<T> dataTreeIdentifier) {
        Preconditions.checkNotNull((Object)dataBroker, (Object)"Can not instantiate Listener! Broker is null!");
        Preconditions.checkNotNull(dataTreeIdentifier, (Object)"DataTreeIndentifier can not be null!");
        this.dataProcessor = dataProcessor;
        this.dataTreeChangeListenerRegistration = dataBroker.registerDataTreeChangeListener(dataTreeIdentifier, (DataTreeChangeListener)this);
    }

    public static <T extends DataObject> DelegatingDataTreeListener initiateListener(Class<T> dataObject, ILispNeutronService lispNeutronService, DataBroker dataBroker) {
        if (dataObject == Network.class) {
            return new NetworkListener(new NetworkDataProcessor(lispNeutronService), dataBroker);
        }
        if (dataObject == Subnet.class) {
            return new SubnetListener(new SubnetDataProcessor(lispNeutronService), dataBroker);
        }
        if (dataObject == Port.class) {
            return new PortListener(new PortDataProcessor(lispNeutronService), dataBroker);
        }
        LOG.debug(dataObject.getName() + " listener can not be instantiated.");
        return null;
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<T>> changes) {
        for (DataTreeModification<T> change : changes) {
            DataObject object;
            DataObjectModification mod = change.getRootNode();
            if (mod.getModificationType() == DataObjectModification.ModificationType.WRITE) {
                object = mod.getDataAfter();
                this.dataProcessor.create(object);
                LOG.info(object.toString() + " created.");
                continue;
            }
            if (mod.getModificationType() == DataObjectModification.ModificationType.DELETE) {
                object = mod.getDataBefore();
                this.dataProcessor.delete(object);
                LOG.info(object.toString() + " removed.");
                continue;
            }
            object = mod.getDataAfter();
            this.dataProcessor.update(object);
            LOG.info(object.toString() + " updated.");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.dataTreeChangeListenerRegistration != null) {
            this.dataTreeChangeListenerRegistration.close();
            this.dataTreeChangeListenerRegistration = null;
            LOG.info(this.toString() + " closed");
        }
    }
}

