/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron;

import java.util.List;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.lispflowmapping.neutron.DataProcessor;
import org.opendaylight.lispflowmapping.neutron.ILispNeutronService;
import org.opendaylight.lispflowmapping.neutron.LispUtil;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.HostInformationManager;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.PortData;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.InstanceIdType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.binding.rev150712.PortBindingExtension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.ports.rev150712.port.attributes.FixedIps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.neutron.ports.rev150712.ports.attributes.ports.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortDataProcessor
implements DataProcessor<Port> {
    private static final Logger LOG = LoggerFactory.getLogger(PortDataProcessor.class);
    private volatile ILispNeutronService lispNeutronService;
    private final HostInformationManager hostInformationManager = HostInformationManager.getInstance();

    public PortDataProcessor(ILispNeutronService lispNeutronService) {
        this.lispNeutronService = lispNeutronService;
    }

    @Override
    public void create(Port port) {
        LOG.debug("Neutron Port Created : " + port.toString());
        String hostId = ((PortBindingExtension)port.getAugmentation(PortBindingExtension.class)).getHostId();
        if (hostId == null) {
            LOG.error("Adding new Neutron port to lisp mapping service failed. Port does not have a HostID. Port: {}", (Object)port.toString());
            return;
        }
        List fixedIPs = port.getFixedIps();
        if (fixedIPs != null && fixedIPs.size() > 0) {
            for (FixedIps ip : fixedIPs) {
                Eid eidAddress = this.getEid(port, ip);
                PortData portData = new PortData(port.getUuid().getValue(), eidAddress);
                this.hostInformationManager.addHostRelatedInfo(hostId, portData);
            }
        }
        LOG.info("Neutron Port Created: Port name: " + port.getName() + " Port Fixed IP: " + (port.getFixedIps() != null ? port.getFixedIps().get(0) : "No Fixed IP assigned"));
    }

    private Eid getEid(Port port, FixedIps ip) {
        InstanceIdType vni = new InstanceIdType(Long.valueOf(this.hostInformationManager.getInstanceId(port.getTenantId().getValue())));
        return LispAddressUtil.asIpv4PrefixEid((Ipv4Address)ip.getIpAddress().getIpv4Address(), (InstanceIdType)vni);
    }

    @Override
    public void update(Port port) {
        String hostId = ((PortBindingExtension)port.getAugmentation(PortBindingExtension.class)).getHostId();
        if (hostId == null) {
            LOG.error("Updating port to lisp mapping service failed. Port does not have a HostID. Port: {}", (Object)port.toString());
            return;
        }
        List fixedIPs = port.getFixedIps();
        if (fixedIPs != null && fixedIPs.size() > 0) {
            for (FixedIps ip : fixedIPs) {
                Eid eidAddress = this.getEid(port, ip);
                PortData portData = new PortData(port.getUuid().getValue(), eidAddress);
                this.hostInformationManager.addHostRelatedInfo(hostId, portData);
            }
        }
        LOG.info("Neutron Port updated: Port name: " + port.getName() + " Port Fixed IP: " + (port.getFixedIps() != null ? port.getFixedIps().get(0) : "No Fixed IP assigned"));
        LOG.debug("Neutron Port Updated : " + port.toString());
    }

    @Override
    public void delete(Port port) {
        LOG.info("Neutron Port Deleted: Port name: " + port.getName() + " Port Fixed IP: " + (port.getFixedIps() != null ? port.getFixedIps().get(0) : "No Fixed IP assigned"));
        LOG.debug("Neutron Port Deleted : " + port.toString());
        List fixedIPs = port.getFixedIps();
        if (fixedIPs != null && fixedIPs.size() > 0) {
            for (FixedIps ip : fixedIPs) {
                Eid eidAddress = LispAddressUtil.asIpv4PrefixEid((String)(ip.getIpAddress().getIpv4Address().getValue() + "/32"));
                this.lispNeutronService.getMappingDbService().removeMapping(LispUtil.buildRemoveMappingInput(eidAddress));
                LOG.info("Neutron Port mapping deleted from lisp:  Port Fixed IP: " + ip + "Port host IP: ");
            }
        }
    }
}

