/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.lispflowmapping.neutron.intenthandler.IntentHandlerAsyncExecutorProvider;
import org.opendaylight.lispflowmapping.neutron.intenthandler.listener.service.VbridgeTopologyListenerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupBasedPolicyNeutronIntentHandlerBean
implements AutoCloseable,
BindingAwareProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GroupBasedPolicyNeutronIntentHandlerBean.class);
    private DataBroker dataBroker;
    private MountPointService mountService;
    private VbridgeTopologyListenerService vbridgeTopologyListenerService;
    private IntentHandlerAsyncExecutorProvider intentHandlerAsyncExecutorProvider = IntentHandlerAsyncExecutorProvider.getInstace();

    public GroupBasedPolicyNeutronIntentHandlerBean(BindingAwareBroker bindingAwareBroker) {
        bindingAwareBroker.registerProvider((BindingAwareProvider)this);
    }

    @Override
    public void close() throws Exception {
        LOG.info("Clustering provider closed for {}", (Object)this.getClass().getSimpleName());
        this.intentHandlerAsyncExecutorProvider.close();
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        LOG.info("LFM neutron handler service registered", (Object)this.getClass().getSimpleName());
        this.dataBroker = (DataBroker)session.getSALService(DataBroker.class);
        this.mountService = (MountPointService)session.getSALService(MountPointService.class);
        this.vbridgeTopologyListenerService = VbridgeTopologyListenerService.initialize(this.dataBroker, this.mountService);
    }
}

