/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.listener;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.md.sal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.lispflowmapping.neutron.intenthandler.listener.VppEndpointListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.vbridge.topology.rev160129.network.topology.topology.topology.types.VbridgeTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbridgeTopologyListener
implements ClusteredDataTreeChangeListener<VbridgeTopology>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VbridgeTopologyListener.class);
    private DataBroker dataBroker;
    private MountPointService mountPointService;
    @GuardedBy(value="this")
    private final Map<TopologyKey, VppEndpointListener> domains = new ConcurrentHashMap<TopologyKey, VppEndpointListener>();

    public VbridgeTopologyListener(DataBroker dataBroker, MountPointService mountPointService) {
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.mountPointService = (MountPointService)Preconditions.checkNotNull((Object)mountPointService);
    }

    public synchronized void onDataTreeChanged(@Nonnull Collection<DataTreeModification<VbridgeTopology>> changes) {
        block4: for (DataTreeModification<VbridgeTopology> topologyData : changes) {
            KeyedInstanceIdentifier topologyInstanceIdentifier = (KeyedInstanceIdentifier)topologyData.getRootPath().getRootIdentifier().firstIdentifierOf(Topology.class);
            Preconditions.checkArgument((!topologyInstanceIdentifier.isWildcarded() ? 1 : 0) != 0, (String)"Wildcard topology %s is not supported", (Object)topologyInstanceIdentifier);
            DataObjectModification modification = topologyData.getRootNode();
            switch (modification.getModificationType()) {
                case DELETE: {
                    this.handleVbridgeTopologyDelete((KeyedInstanceIdentifier<Topology, TopologyKey>)topologyInstanceIdentifier);
                    continue block4;
                }
                case WRITE: {
                    this.handleVbridgeTopologyWrite((KeyedInstanceIdentifier<Topology, TopologyKey>)topologyInstanceIdentifier);
                    continue block4;
                }
            }
            LOG.warn("Ignoring unhandled modification type {}", (Object)modification.getModificationType());
        }
    }

    private void handleVbridgeTopologyDelete(KeyedInstanceIdentifier<Topology, TopologyKey> topology) {
        VppEndpointListener endpointListener = this.domains.get(topology.getKey());
        endpointListener.close();
        this.domains.remove(topology.getKey());
    }

    private void handleVbridgeTopologyWrite(KeyedInstanceIdentifier<Topology, TopologyKey> topology) {
        if (this.domains.containsKey(topology.getKey())) {
            this.domains.get(topology.getKey()).close();
            this.domains.remove(topology.getKey());
        }
        this.domains.put((TopologyKey)topology.getKey(), new VppEndpointListener(this.dataBroker, this.mountPointService, topology));
    }

    @Override
    public void close() {
        this.domains.forEach((topologyKey, vppEndpointListener) -> vppEndpointListener.close());
    }
}

