/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.intenthandler.util;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.lispflowmapping.neutron.intenthandler.exception.RlocNotFoundOnVppNode;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.InfoUtil;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.LispNeutronUtil;
import org.opendaylight.lispflowmapping.neutron.intenthandler.util.VppNetconfTrasaction;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfacesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.Interface;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.Interface2;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.Ipv4;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ip.rev140616.interfaces.state._interface.ipv4.Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.Loopback;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VppNodeReader {
    private static final Logger LOG = LoggerFactory.getLogger(VppNodeReader.class);
    private final DataBroker dataBroker;
    private final MountPointService mountService;

    public VppNodeReader(DataBroker dataBroker, MountPointService mountService) {
        this.dataBroker = dataBroker;
        this.mountService = mountService;
    }

    public Ipv4Address rlocIpOfNode(KeyedInstanceIdentifier<Node, NodeKey> instanceIdentifierToVppNode) {
        try {
            Optional ipv4AddressOptional = (Optional)this.readFirstAvailableIpOfVppNode(instanceIdentifierToVppNode).get();
            if (!ipv4AddressOptional.isPresent()) {
                throw new RlocNotFoundOnVppNode(InfoUtil.node(instanceIdentifierToVppNode));
            }
            return (Ipv4Address)ipv4AddressOptional.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn("Got exception while reading IP addresses from nodes {}", (Object)InfoUtil.node(instanceIdentifierToVppNode));
            throw new RlocNotFoundOnVppNode(InfoUtil.node(instanceIdentifierToVppNode), ex);
        }
    }

    private ListenableFuture<Optional<Ipv4Address>> readFirstAvailableIpOfVppNode(KeyedInstanceIdentifier<Node, NodeKey> instanceIdentifierToVppNode) {
        SettableFuture resultFuture = SettableFuture.create();
        DataBroker vppDataBroker = LispNeutronUtil.resolveDataBrokerForMountPoint(instanceIdentifierToVppNode, this.mountService);
        if (vppDataBroker != null) {
            Optional interfacesOnVppNodeOptional = VppNetconfTrasaction.read(vppDataBroker, LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(InterfacesState.class));
            if (interfacesOnVppNodeOptional.isPresent()) {
                for (Interface intf : ((InterfacesState)interfacesOnVppNodeOptional.get()).getInterface()) {
                    Optional<Ipv4Address> ipv4AddressOptional;
                    if (intf.getType().equals(Loopback.class) || !(ipv4AddressOptional = this.readIpAddressFromInterface(intf, instanceIdentifierToVppNode)).isPresent()) continue;
                    resultFuture.set(ipv4AddressOptional);
                    break;
                }
            }
            resultFuture.set((Object)Optional.absent());
        } else {
            LOG.debug("Data broker for vpp {} is missing.", instanceIdentifierToVppNode);
        }
        return resultFuture;
    }

    private Optional<Ipv4Address> readIpAddressFromInterface(Interface intf, KeyedInstanceIdentifier iiToVpp) {
        Interface2 augIntf = (Interface2)intf.getAugmentation(Interface2.class);
        if (augIntf == null) {
            LOG.debug("Cannot get Interface2 augmentation for intf {}");
            return Optional.absent();
        }
        Ipv4 ipv4 = augIntf.getIpv4();
        if (ipv4 == null) {
            LOG.debug("Ipv4 address for interface {} on node {} is null!", (Object)augIntf, (Object)InfoUtil.node((KeyedInstanceIdentifier<Node, NodeKey>)iiToVpp));
            return Optional.absent();
        }
        List addresses = ipv4.getAddress();
        if (addresses == null || addresses.isEmpty()) {
            LOG.debug("Ipv4 addresses list is empty for interface {} on node {}", (Object)augIntf, (Object)InfoUtil.node((KeyedInstanceIdentifier<Node, NodeKey>)iiToVpp));
            return Optional.absent();
        }
        Ipv4AddressNoZone ip = ((Address)addresses.iterator().next()).getIp();
        if (ip == null) {
            LOG.debug("Ipv4AddressNoZone is null for node {}", (Object)InfoUtil.node((KeyedInstanceIdentifier<Node, NodeKey>)iiToVpp));
            return Optional.absent();
        }
        LOG.debug("Got ip address {} from interface {} on node {}", new Object[]{ip.getValue(), intf.getName(), InfoUtil.node((KeyedInstanceIdentifier<Node, NodeKey>)iiToVpp)});
        return Optional.of((Object)ip);
    }
}

