/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers;

import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.PortData;
import org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers.PortUuidToPortDataMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostIdToPortDataMapper {
    private static final Logger LOG = LoggerFactory.getLogger(HostIdToPortDataMapper.class);
    private ConcurrentHashMap<String, PortUuidToPortDataMapper> mapper = new ConcurrentHashMap();

    public synchronized void addMapping(String hostId, PortData portData) {
        PortUuidToPortDataMapper uuidToEidMapper = this.mapper.get(hostId);
        if (uuidToEidMapper == null) {
            uuidToEidMapper = new PortUuidToPortDataMapper();
            this.mapper.put(hostId, uuidToEidMapper);
        }
        uuidToEidMapper.addUnprocessedUuidToPortDataMapping(portData.getPortUuid(), portData);
        LOG.debug("Adding " + portData.getPortEid().getAddress() + " as EID of " + portData.getPortUuid() + " belonging to " + hostId);
    }

    public final PortUuidToPortDataMapper getAllPortData(String hostId) {
        return this.mapper.get(hostId);
    }
}

