/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron.mappingmanager.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.rloc.container.Rloc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostIdToRlocMapper {
    private static final Logger LOG = LoggerFactory.getLogger(HostIdToRlocMapper.class);
    private ConcurrentHashMap<String, List<Rloc>> mapper = new ConcurrentHashMap();

    public synchronized void addMapping(String hostId, Rloc hostRloc) {
        List<Rloc> hostIdSpeceficRlocs = this.mapper.get(hostId);
        if (hostIdSpeceficRlocs == null) {
            hostIdSpeceficRlocs = new ArrayList<Rloc>();
        }
        hostIdSpeceficRlocs.add(hostRloc);
        this.mapper.put(hostId, hostIdSpeceficRlocs);
        LOG.debug("Adding " + hostRloc.getAddress() + " as Rloc of " + hostId);
    }

    public List<Rloc> getRlocs(String hostId) {
        return this.mapper.get(hostId);
    }

    public synchronized void deleteMapping(String hostId) {
        this.mapper.remove(hostId);
    }
}

