/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.northbound;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.lispflowmapping.type.AddressFamilyNumberEnum;
import org.opendaylight.lispflowmapping.type.LispCanonicalAddressFormatEnum;
import org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord;
import org.opendaylight.lispflowmapping.type.lisp.LocatorRecord;
import org.opendaylight.lispflowmapping.type.lisp.MapRegister;
import org.opendaylight.lispflowmapping.type.lisp.address.LispASAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispAddressGeneric;
import org.opendaylight.lispflowmapping.type.lisp.address.LispApplicationDataLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispDistinguishedNameAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispIpv4Address;
import org.opendaylight.lispflowmapping.type.lisp.address.LispIpv6Address;
import org.opendaylight.lispflowmapping.type.lisp.address.LispListLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispMACAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispSegmentLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispSourceDestLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispTrafficEngineeringLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispAddressConvertorNB {
    protected static final Logger logger = LoggerFactory.getLogger(LispAddressConvertorNB.class);

    public static LispAddress convertToLispAddress(LispAddressGeneric generic) {
        if (generic == null) {
            logger.warn("Couldn't convert address, generic address is null");
            return null;
        }
        LispIpv4Address lispAddress = null;
        AddressFamilyNumberEnum afiEnum = AddressFamilyNumberEnum.valueOf((short)((short)generic.getAfi()));
        block0 : switch (afiEnum) {
            case IP: {
                lispAddress = new LispIpv4Address(generic.getIpAddress());
                if (lispAddress.getAddress() != null) break;
                throw new IllegalArgumentException("Convertor was unable to convert address");
            }
            case AS: {
                lispAddress = new LispASAddress(generic.getAsNum());
                break;
            }
            case IP6: {
                lispAddress = new LispIpv6Address(generic.getIpAddress());
                if (((LispIpv6Address)lispAddress).getAddress() != null) break;
                throw new IllegalArgumentException("Convertor was unable to convert address");
            }
            case MAC: {
                lispAddress = new LispMACAddress(generic.getMac());
                break;
            }
            case DISTINGUISHED_NAME: {
                lispAddress = new LispDistinguishedNameAddress(generic.getDistinguishedName());
                break;
            }
            case LCAF: {
                LispCanonicalAddressFormatEnum lcafEnum = LispCanonicalAddressFormatEnum.valueOf((int)generic.getLcafType());
                switch (lcafEnum) {
                    case APPLICATION_DATA: {
                        lispAddress = LispAddressConvertorNB.convertToApplicationData(generic);
                        break block0;
                    }
                    case LIST: {
                        lispAddress = LispAddressConvertorNB.convertToList(generic);
                        break block0;
                    }
                    case SEGMENT: {
                        lispAddress = LispAddressConvertorNB.convertToSegment(generic);
                        break block0;
                    }
                    case SOURCE_DEST: {
                        lispAddress = LispAddressConvertorNB.convertToSrcDst(generic);
                        break block0;
                    }
                    case TRAFFIC_ENGINEERING: {
                        lispAddress = LispAddressConvertorNB.convertToTE(generic);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("LCAF type " + lcafEnum + " not supported by this convertor: convertToLispAddress(LispAddressGeneric generic)");
            }
            default: {
                throw new IllegalArgumentException("AFI " + afiEnum + " not supported by this convertor: convertToLispAddress(LispAddressGeneric generic)");
            }
        }
        return lispAddress;
    }

    private static LispApplicationDataLCAFAddress convertToApplicationData(LispAddressGeneric generic) {
        return new LispApplicationDataLCAFAddress(0, generic.getProtocol(), generic.getIpTos(), generic.getLocalPort(), generic.getRemotePort(), LispAddressConvertorNB.convertToLispAddress(generic.getAddress()));
    }

    private static LispListLCAFAddress convertToList(LispAddressGeneric generic) {
        ArrayList<LispAddress> list = new ArrayList<LispAddress>();
        for (int i = 0; i < generic.getAddresses().size(); ++i) {
            list.add(LispAddressConvertorNB.convertToLispAddress((LispAddressGeneric)generic.getAddresses().get(i)));
        }
        return new LispListLCAFAddress(0, list);
    }

    private static LispSegmentLCAFAddress convertToSegment(LispAddressGeneric generic) {
        byte idMaskLen = 0;
        return new LispSegmentLCAFAddress(idMaskLen, generic.getInstanceId(), LispAddressConvertorNB.convertToLispAddress(generic.getAddress()));
    }

    private static LispSourceDestLCAFAddress convertToSrcDst(LispAddressGeneric generic) {
        return new LispSourceDestLCAFAddress(0, 0, generic.getSrcMaskLength(), generic.getDstMaskLength(), LispAddressConvertorNB.convertToLispAddress(generic.getSrcAddress()), LispAddressConvertorNB.convertToLispAddress(generic.getDstAddress()));
    }

    private static LispTrafficEngineeringLCAFAddress convertToTE(LispAddressGeneric generic) {
        ArrayList<ReencapHop> listHops = new ArrayList<ReencapHop>();
        for (int i = 0; i < generic.getHops().size(); ++i) {
            ReencapHop hop = new ReencapHop(LispAddressConvertorNB.convertToLispAddress(((LispAddressGeneric)generic.getHops().get(i)).getAddress()), 0, generic.isLookup(), generic.isRLOCProbe(), generic.isStrict());
            listHops.add(hop);
        }
        return new LispTrafficEngineeringLCAFAddress(0, listHops);
    }

    public static void convertGenericToLispAddresses(MapRegister mapRegister) {
        if (mapRegister == null) {
            logger.warn("Couldn't convert addresses, mapRegister is null");
            return;
        }
        int EIDtoLocatorRecordCount = mapRegister.getEidToLocatorRecords().size();
        for (int i = 0; i < EIDtoLocatorRecordCount; ++i) {
            LispAddressGeneric EIDGeneric = ((EidToLocatorRecord)mapRegister.getEidToLocatorRecords().get(i)).getPrefixGeneric();
            LispAddress EID = LispAddressConvertorNB.convertToLispAddress(EIDGeneric);
            ((EidToLocatorRecord)mapRegister.getEidToLocatorRecords().get(i)).setPrefix(EID);
            List locRecordList = ((EidToLocatorRecord)mapRegister.getEidToLocatorRecords().get(i)).getLocators();
            for (int j = 0; j < locRecordList.size(); ++j) {
                LispAddressGeneric RLOCGeneric = ((LocatorRecord)locRecordList.get(j)).getLocatorGeneric();
                LispAddress RLOC = LispAddressConvertorNB.convertToLispAddress(RLOCGeneric);
                ((LocatorRecord)locRecordList.get(j)).setLocator(RLOC);
            }
        }
    }

    public static void convertRecordToGenericAddress(EidToLocatorRecord record) {
        if (record == null) {
            logger.warn("Couldn't convert addresses, record is null");
            return;
        }
        LispAddress EID = record.getPrefix();
        record.setPrefixGeneric(new LispAddressGeneric(EID));
        List locRecordList = record.getLocators();
        for (int j = 0; j < locRecordList.size(); ++j) {
            LispAddress RLOC = ((LocatorRecord)locRecordList.get(j)).getLocator();
            ((LocatorRecord)locRecordList.get(j)).setLocatorGeneric(new LispAddressGeneric(RLOC));
        }
    }
}

