/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.northbound;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.lispflowmapping.interfaces.lisp.IFlowMapping;
import org.opendaylight.lispflowmapping.northbound.AuthKeyNB;
import org.opendaylight.lispflowmapping.northbound.ILispmappingNorthbound;
import org.opendaylight.lispflowmapping.northbound.LispAddressConvertorNB;
import org.opendaylight.lispflowmapping.northbound.MapRegisterNB;
import org.opendaylight.lispflowmapping.northbound.YangTransformerNB;
import org.opendaylight.lispflowmapping.type.AddressFamilyNumberEnum;
import org.opendaylight.lispflowmapping.type.LispCanonicalAddressFormatEnum;
import org.opendaylight.lispflowmapping.type.lisp.EidRecord;
import org.opendaylight.lispflowmapping.type.lisp.MapRequest;
import org.opendaylight.lispflowmapping.type.lisp.address.LispAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispAddressGeneric;
import org.opendaylight.lispflowmapping.type.lisp.address.LispIpv4Address;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapNotify;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRegister;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapReply;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.eidtolocatorrecords.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.LispAddressContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class LispMappingNorthbound
implements ILispmappingNorthbound {
    protected static final Logger logger = LoggerFactory.getLogger(LispMappingNorthbound.class);
    private IFlowMapping mappingService;
    private String userName;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.userName = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.userName;
    }

    @Override
    public IFlowMapping getMappingService() {
        return this.mappingService;
    }

    void setFlowMappingService(IFlowMapping mappingService) {
        logger.trace("FlowMapping set in LispNorthbound");
        this.mappingService = mappingService;
    }

    void unsetFlowMappingService(IFlowMapping mappingService) {
        logger.trace("LispDAO was unset in LISP Northbound");
        this.mappingService = null;
    }

    public void init() {
        logger.trace("LISP Northbound Service is initialized!");
    }

    public void start() {
        logger.info("LISP Northbound Service is up!");
    }

    public void stop() {
        logger.info("LISP Northbound Service is down!");
    }

    public void destroy() {
        logger.trace("LISP Northbound Service is destroyed!");
        this.mappingService = null;
    }

    private void handleContainerDoesNotExist(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + containerName + RestMessages.NOCONTAINER.toString());
        }
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            return;
        }
        throw new ResourceNotFoundException("Container " + containerName + " " + RestMessages.NOCONTAINER.toString());
    }

    private void authorizationCheck(String containerName, Privilege privilege) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)privilege, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
    }

    private EidToLocatorRecord lookupEID(String containerName, int mask, LispAddress EID) {
        MapReply mapReply;
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        MapRequest mapRequest = new MapRequest();
        EidRecord EIDRecord = new EidRecord((byte)mask, EID);
        mapRequest.addEidRecord(EIDRecord);
        mapRequest.setSourceEid((LispAddress)new LispIpv4Address("127.0.0.1"));
        org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRequest mr = YangTransformerNB.transformMapRequest(mapRequest);
        try {
            mapReply = nbService.getMappingService().handleMapRequest(mr);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error looking up the EID");
        }
        if (mapReply == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error looking up the EID");
        }
        EidToLocatorRecord record = null;
        record = (EidToLocatorRecord)mapReply.getEidToLocatorRecord().get(0);
        return record;
    }

    private void keyCheck(IFlowMapping mappingService, MapRegisterNB mapRegisterNB) {
        String usedKey = mapRegisterNB.getKey();
        int numEidRecords = mapRegisterNB.getMapRegister().getEidToLocatorRecords().size();
        for (int i = 0; i < numEidRecords; ++i) {
            String storedKey;
            LispAddress lispAddress;
            LispAddressGeneric lispAddressGeneric = ((org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord)mapRegisterNB.getMapRegister().getEidToLocatorRecords().get(i)).getPrefixGeneric();
            try {
                lispAddress = LispAddressConvertorNB.convertToLispAddress(lispAddressGeneric);
            }
            catch (Exception e) {
                throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
            }
            int mask = ((org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord)mapRegisterNB.getMapRegister().getEidToLocatorRecords().get(i)).getMaskLength();
            try {
                storedKey = mappingService.getAuthenticationKey(YangTransformerNB.transformLispAddress(lispAddress), mask);
            }
            catch (Exception e) {
                throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while retrieving the key");
            }
            if (usedKey.equals(storedKey)) continue;
            throw new UnauthorizedException("The key used to register the mapping does not match with the stored key for that mapping");
        }
    }

    @Path(value="/{containerName}/mapping")
    @PUT
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Addition of mapping failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response addMapping(@PathParam(value="containerName") String containerName, @TypeHint(value=MapRegisterNB.class) MapRegisterNB mapRegisterNB) {
        MapNotify mapNotify;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.WRITE);
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        try {
            this.keyCheck(nbService.getMappingService(), mapRegisterNB);
            LispAddressConvertorNB.convertGenericToLispAddresses(mapRegisterNB.getMapRegister());
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        mapRegisterNB.getMapRegister().setWantMapNotify(true);
        MapRegister mr = null;
        try {
            mr = YangTransformerNB.transformMapRegister(mapRegisterNB.getMapRegister());
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while converting the map register");
        }
        try {
            mapNotify = nbService.getMappingService().handleMapRegister(mr);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while registering the mapping");
        }
        if (mapNotify == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while registering the mapping");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private LispAddressGeneric parseAddressURL(int iid, int afi, String address, int mask) {
        LispAddressGeneric eidGeneric = new LispAddressGeneric(afi, address);
        if (iid != 0) {
            eidGeneric = new LispAddressGeneric((int)AddressFamilyNumberEnum.LCAF.getIanaCode(), eidGeneric);
            eidGeneric.setLcafType((int)LispCanonicalAddressFormatEnum.SEGMENT.getLispCode());
            eidGeneric.setInstanceId(iid);
        }
        return eidGeneric;
    }

    private LispAddressGeneric parseSrcDstAddressURL(int iid, int afi, String srcAdd, int srcML, String dstAdd, int dstML) {
        LispAddressGeneric srcGeneric = new LispAddressGeneric(afi, srcAdd);
        LispAddressGeneric dstGeneric = new LispAddressGeneric(afi, dstAdd);
        if (iid != 0) {
            srcGeneric = new LispAddressGeneric((int)AddressFamilyNumberEnum.LCAF.getIanaCode(), srcGeneric);
            srcGeneric.setLcafType((int)LispCanonicalAddressFormatEnum.SEGMENT.getLispCode());
            srcGeneric.setInstanceId(iid);
            dstGeneric = new LispAddressGeneric((int)AddressFamilyNumberEnum.LCAF.getIanaCode(), dstGeneric);
            dstGeneric.setLcafType((int)LispCanonicalAddressFormatEnum.SEGMENT.getLispCode());
            dstGeneric.setInstanceId(iid);
        }
        LispAddressGeneric address = new LispAddressGeneric((int)AddressFamilyNumberEnum.LCAF.getIanaCode());
        address.setLcafType((int)LispCanonicalAddressFormatEnum.SOURCE_DEST.getLispCode());
        address.setSrcAddress(srcGeneric);
        address.setSrcMaskLength((byte)srcML);
        address.setDstAddress(dstGeneric);
        address.setDstMaskLength((byte)dstML);
        return address;
    }

    @Path(value="/{containerName}/mapping/{iid}/{afi}/{address}/{mask}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Get mapping failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord getMapping(@PathParam(value="containerName") String containerName, @PathParam(value="iid") int iid, @PathParam(value="afi") int afi, @PathParam(value="address") String address, @PathParam(value="mask") int mask) {
        LispAddress eid;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.READ);
        LispAddressGeneric eidGeneric = this.parseAddressURL(iid, afi, address, mask);
        try {
            eid = LispAddressConvertorNB.convertToLispAddress(eidGeneric);
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        EidToLocatorRecord record = this.lookupEID(containerName, mask, eid);
        org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord legacyRecord = YangTransformerNB.reTransformEidToLocatorRecord(record);
        LispAddressConvertorNB.convertRecordToGenericAddress(legacyRecord);
        return legacyRecord;
    }

    @Path(value="/{containerName}/mapping/{iid}/{afi}/{srcAdd}/{srcML}/{dstAdd}/{dstML}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=503, condition="Service unavailable")})
    public org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord getMapping(@PathParam(value="containerName") String containerName, @PathParam(value="iid") int iid, @PathParam(value="afi") int afi, @PathParam(value="srcAdd") String srcAdd, @PathParam(value="srcML") int srcML, @PathParam(value="dstAdd") String dstAdd, @PathParam(value="dstML") int dstML) {
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.READ);
        LispAddressGeneric eidGeneric = this.parseSrcDstAddressURL(iid, afi, srcAdd, srcML, dstAdd, dstML);
        int mask = 0;
        EidToLocatorRecord record = this.lookupEID(containerName, mask, LispAddressConvertorNB.convertToLispAddress(eidGeneric));
        org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord legacyRecord = YangTransformerNB.reTransformEidToLocatorRecord(record);
        LispAddressConvertorNB.convertRecordToGenericAddress(legacyRecord);
        return legacyRecord;
    }

    @Path(value="/{containerName}/key")
    @PUT
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Addition of key failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response addAuthKey(@PathParam(value="containerName") String containerName, @TypeHint(value=AuthKeyNB.class) AuthKeyNB authKeyNB) {
        LispAddress lispAddress;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.WRITE);
        try {
            lispAddress = LispAddressConvertorNB.convertToLispAddress(authKeyNB.getAddress());
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        boolean success = false;
        try {
            success = nbService.getMappingService().addAuthenticationKey(YangTransformerNB.transformLispAddress(lispAddress), authKeyNB.getMaskLength(), authKeyNB.getKey());
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while adding the key");
        }
        if (!success) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while adding the key");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="/{containerName}/key/{iid}/{afi}/{address}/{mask}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Get key failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public AuthKeyNB getAuthKey(@PathParam(value="containerName") String containerName, @PathParam(value="iid") int iid, @PathParam(value="afi") int afi, @PathParam(value="address") String address, @PathParam(value="mask") int mask) {
        String key;
        LispAddress lispAddress;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.READ);
        LispAddressGeneric lispAddressGeneric = this.parseAddressURL(iid, afi, address, mask);
        try {
            lispAddress = LispAddressConvertorNB.convertToLispAddress(lispAddressGeneric);
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        try {
            key = nbService.getMappingService().getAuthenticationKey(YangTransformerNB.transformLispAddress(lispAddress), mask);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while retrieving the key");
        }
        if (key == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while retrieving the key");
        }
        AuthKeyNB authKeyNB = new AuthKeyNB();
        authKeyNB.setKey(key);
        authKeyNB.setAddress(lispAddressGeneric);
        authKeyNB.setMaskLength(mask);
        return authKeyNB;
    }

    @Path(value="/{containerName}/key/{iid}/{afi}/{srcAdd}/{srcML}/{dstAdd}/{dstML}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=503, condition="Service unavailable")})
    public AuthKeyNB getAuthKey(@PathParam(value="containerName") String containerName, @PathParam(value="iid") int iid, @PathParam(value="afi") int afi, @PathParam(value="srcAdd") String srcAdd, @PathParam(value="srcML") int srcML, @PathParam(value="dstAdd") String dstAdd, @PathParam(value="dstML") int dstML) {
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.READ);
        LispAddressGeneric lispAddressGeneric = this.parseSrcDstAddressURL(iid, afi, srcAdd, srcML, dstAdd, dstML);
        LispAddress lispAddress = LispAddressConvertorNB.convertToLispAddress(lispAddressGeneric);
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        int mask = 0;
        LispAddressContainer yangAddress = YangTransformerNB.transformLispAddress(lispAddress);
        String key = nbService.getMappingService().getAuthenticationKey(yangAddress, mask);
        if (key == null) {
            return null;
        }
        AuthKeyNB authKeyNB = new AuthKeyNB();
        authKeyNB.setKey(key);
        authKeyNB.setAddress(lispAddressGeneric);
        authKeyNB.setMaskLength(mask);
        return authKeyNB;
    }

    @Path(value="/{containerName}/key/{iid}/{afi}/{address}/{mask}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Delete key failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response delAuthKey(@PathParam(value="containerName") String containerName, @PathParam(value="afi") int afi, @PathParam(value="iid") int iid, @PathParam(value="address") String address, @PathParam(value="mask") int mask) {
        LispAddress lispAddress;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.WRITE);
        LispAddressGeneric lispAddressGeneric = this.parseAddressURL(iid, afi, address, mask);
        try {
            lispAddress = LispAddressConvertorNB.convertToLispAddress(lispAddressGeneric);
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        boolean success = false;
        try {
            success = nbService.getMappingService().removeAuthenticationKey(YangTransformerNB.transformLispAddress(lispAddress), mask);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while deleting the key");
        }
        if (!success) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while deleting the key");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="/{containerName}/key/{iid}/{afi}/{srcAdd}/{srcML}/{dstAdd}/{dstML}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=404, condition="The containerName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error: Delete key failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response delAuthKey(@PathParam(value="containerName") String containerName, @PathParam(value="iid") int iid, @PathParam(value="afi") int afi, @PathParam(value="srcAdd") String srcAdd, @PathParam(value="srcML") int srcML, @PathParam(value="dstAdd") String dstAdd, @PathParam(value="dstML") int dstML) {
        LispAddress lispAddress;
        this.handleContainerDoesNotExist(containerName);
        this.authorizationCheck(containerName, Privilege.WRITE);
        LispAddressGeneric lispAddressGeneric = this.parseSrcDstAddressURL(iid, afi, srcAdd, srcML, dstAdd, dstML);
        try {
            lispAddress = LispAddressConvertorNB.convertToLispAddress(lispAddressGeneric);
        }
        catch (Exception e) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Address is not valid");
        }
        ILispmappingNorthbound nbService = (ILispmappingNorthbound)ServiceHelper.getInstance(ILispmappingNorthbound.class, (String)containerName, (Object)this);
        int mask = 0;
        boolean success = false;
        try {
            success = nbService.getMappingService().removeAuthenticationKey(YangTransformerNB.transformLispAddress(lispAddress), mask);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while deleting the key");
        }
        if (!success) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString() + " : There was an error while deleting the key");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

