/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.northbound;

import java.util.ArrayList;
import javax.xml.bind.DatatypeConverter;
import org.opendaylight.lispflowmapping.type.AddressFamilyNumberEnum;
import org.opendaylight.lispflowmapping.type.LispCanonicalAddressFormatEnum;
import org.opendaylight.lispflowmapping.type.lisp.EidRecord;
import org.opendaylight.lispflowmapping.type.lisp.LocatorRecord;
import org.opendaylight.lispflowmapping.type.lisp.MapReplyAction;
import org.opendaylight.lispflowmapping.type.lisp.MapRequest;
import org.opendaylight.lispflowmapping.type.lisp.address.LispASAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispApplicationDataLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispIpv4Address;
import org.opendaylight.lispflowmapping.type.lisp.address.LispIpv6Address;
import org.opendaylight.lispflowmapping.type.lisp.address.LispLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispListLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispMACAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispNoAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispSegmentLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispSourceDestLCAFAddress;
import org.opendaylight.lispflowmapping.type.lisp.address.LispTrafficEngineeringLCAFAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LcafApplicationDataAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LcafListAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LcafSegmentAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LcafSourceDestAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LcafTrafficEngineeringAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispAFIAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispDistinguishedNameAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispLcafAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispMacAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRegister;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.ReencapHop;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.eidrecords.EidRecordBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.eidtolocatorrecords.EidToLocatorRecord;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.eidtolocatorrecords.EidToLocatorRecordBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafapplicationdataaddress.Address;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafapplicationdataaddress.AddressBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcaflistaddress.Addresses;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcaflistaddress.AddressesBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsourcedestaddress.DstAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsourcedestaddress.DstAddressBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsourcedestaddress.SrcAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsourcedestaddress.SrcAddressBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcaftrafficengineeringaddress.Hops;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcaftrafficengineeringaddress.HopsBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.LispAddressContainer;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.LispAddressContainerBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.DistinguishedNameBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Ipv4;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Ipv6;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Ipv6Builder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.LcafApplicationDataBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.LcafListBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.LcafSegmentBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.LcafSourceDestBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.LcafTrafficEngineeringBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Mac;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.NoBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.PrimitiveAddress;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.AS;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.ASBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.DistinguishedName;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv4Builder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.MacBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecordBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.mapregisternotification.MapRegisterBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.maprequest.ItrRlocBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.maprequest.SourceEidBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.maprequestnotification.MapRequestBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.reencaphop.Hop;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.reencaphop.HopBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;

public class YangTransformerNB {
    public static LispAddressContainer toContainer(LispAFIAddress address) {
        if (address instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.Address) {
            return new LispAddressContainerBuilder().setAddress((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.Address)address).build();
        }
        return null;
    }

    public static LispAFIAddress toAFI(LispAddressContainer container) {
        return (LispAFIAddress)container.getAddress();
    }

    public static PrimitiveAddress toPrimitive(LispAFIAddress address) {
        if (address instanceof Ipv4) {
            return new Ipv4Builder().setIpv4Address(((Ipv4)address).getIpv4Address()).setAfi(address.getAfi()).build();
        }
        if (address instanceof Ipv6) {
            return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv6Builder().setIpv6Address(((Ipv6)address).getIpv6Address()).setAfi(address.getAfi()).build();
        }
        if (address instanceof Mac) {
            return new MacBuilder().setAfi(address.getAfi()).setMacAddress(((Mac)address).getMacAddress()).build();
        }
        if (address instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.DistinguishedName) {
            return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.DistinguishedNameBuilder().setAfi(address.getAfi()).setDistinguishedName(((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.DistinguishedName)address).getDistinguishedName()).build();
        }
        if (address instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.AS) {
            return new ASBuilder().setAfi(address.getAfi()).setAS(((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.AS)address).getAS()).build();
        }
        return null;
    }

    public static LispAFIAddress toAFIfromPrimitive(PrimitiveAddress primitive) {
        if (primitive instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv4) {
            return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Ipv4Builder().setAfi(((LispAFIAddress)primitive).getAfi()).setIpv4Address(((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv4)primitive).getIpv4Address()).build();
        }
        if (primitive instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv6) {
            return new Ipv6Builder().setAfi(((LispAFIAddress)primitive).getAfi()).setIpv6Address(((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Ipv6)primitive).getIpv6Address()).build();
        }
        if (primitive instanceof org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Mac) {
            return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.MacBuilder().setAfi(((LispAFIAddress)primitive).getAfi()).setMacAddress(((org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispsimpleaddress.primitiveaddress.Mac)primitive).getMacAddress()).build();
        }
        if (primitive instanceof DistinguishedName) {
            return new DistinguishedNameBuilder().setAfi(((LispAFIAddress)primitive).getAfi()).setDistinguishedName(((DistinguishedName)primitive).getDistinguishedName()).build();
        }
        if (primitive instanceof AS) {
            return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.ASBuilder().setAfi(((LispAFIAddress)primitive).getAfi()).setAS(((AS)primitive).getAS()).build();
        }
        return null;
    }

    public static LispAddressContainer transformLispAddress(LispAddress lispAddress) {
        if (lispAddress == null) {
            return null;
        }
        LispAFIAddress lispAFIAddress = null;
        short ianaCode = lispAddress.getAfi().getIanaCode();
        block0 : switch (lispAddress.getAfi()) {
            case IP: {
                LispIpv4Address lispIpv4Address = (LispIpv4Address)lispAddress;
                Ipv4Address ipv4Address = new Ipv4Address(lispIpv4Address.getAddress().getHostAddress());
                lispAFIAddress = new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.Ipv4Builder().setIpv4Address(ipv4Address).setAfi(Short.valueOf(ianaCode)).build();
                break;
            }
            case NO_ADDRESS: {
                lispAFIAddress = new NoBuilder().setAfi(Short.valueOf(ianaCode)).build();
            }
            case AS: {
                LispASAddress lispASAddress = (LispASAddress)lispAddress;
                lispAFIAddress = new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.ASBuilder().setAS(Integer.valueOf(lispASAddress.getAS())).setAfi(Short.valueOf(ianaCode)).build();
                break;
            }
            case DISTINGUISHED_NAME: {
                org.opendaylight.lispflowmapping.type.lisp.address.LispDistinguishedNameAddress lispDNAddress = (org.opendaylight.lispflowmapping.type.lisp.address.LispDistinguishedNameAddress)lispAddress;
                lispAFIAddress = new DistinguishedNameBuilder().setDistinguishedName(lispDNAddress.getDistinguishedName()).setAfi(Short.valueOf(ianaCode)).build();
                break;
            }
            case IP6: {
                LispIpv6Address lispIpv6Address = (LispIpv6Address)lispAddress;
                Ipv6Address ipv6Address = new Ipv6Address(lispIpv6Address.getAddress().getHostAddress());
                lispAFIAddress = new Ipv6Builder().setIpv6Address(ipv6Address).setAfi(Short.valueOf(ianaCode)).build();
                break;
            }
            case MAC: {
                lispAFIAddress = YangTransformerNB.transformLispMACAddress(lispAddress);
                break;
            }
            case LCAF: {
                LispLCAFAddress lispLcafAddress = (LispLCAFAddress)lispAddress;
                LispCanonicalAddressFormatEnum lcafEnum = lispLcafAddress.getType();
                switch (lcafEnum) {
                    case APPLICATION_DATA: {
                        lispAFIAddress = YangTransformerNB.transformLispApplicationDataLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case LIST: {
                        lispAFIAddress = YangTransformerNB.transformLispListLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case SEGMENT: {
                        lispAFIAddress = YangTransformerNB.transformLispSegmentLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case SOURCE_DEST: {
                        lispAFIAddress = YangTransformerNB.transformLispSourceDestLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case TRAFFIC_ENGINEERING: {
                        lispAFIAddress = YangTransformerNB.transformLispTrafficEngineeringLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("LCAF type " + lcafEnum + " not supported by this transoformer");
            }
            default: {
                throw new IllegalArgumentException("AFI " + lispAddress.getAfi() + " not supported by this transformer");
            }
        }
        return YangTransformerNB.toContainer(lispAFIAddress);
    }

    public static LispAFIAddress transformLispMACAddress(LispAddress lispAddress) {
        LispMACAddress lispMacAddress = (LispMACAddress)lispAddress;
        StringBuilder sb = new StringBuilder(17);
        for (byte b : lispMacAddress.getMAC()) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
        }
        return new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.address.MacBuilder().setAfi(Short.valueOf(lispMacAddress.getAfi().getIanaCode())).setMacAddress(new MacAddress(sb.toString())).build();
    }

    public static LispAFIAddress transformLispApplicationDataLCAFAddress(LispLCAFAddress lispLcafAddress) {
        LispApplicationDataLCAFAddress lispApplicationDataLCAFAddress = (LispApplicationDataLCAFAddress)lispLcafAddress;
        Address address = new AddressBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress(lispApplicationDataLCAFAddress.getAddress())))).build();
        return new LcafApplicationDataBuilder().setAfi(Short.valueOf(lispLcafAddress.getAfi().getIanaCode())).setLcafType(Short.valueOf(lispLcafAddress.getType().getLispCode())).setIpTos(Integer.valueOf(lispApplicationDataLCAFAddress.getIPTos())).setLocalPort(new PortNumber(Integer.valueOf(lispApplicationDataLCAFAddress.getLocalPort()))).setRemotePort(new PortNumber(Integer.valueOf(lispApplicationDataLCAFAddress.getRemotePort()))).setAddress(address).build();
    }

    public static LispAFIAddress transformLispListLCAFAddress(LispLCAFAddress lispLcafAddress) {
        LispListLCAFAddress lispListLCAFAddress = (LispListLCAFAddress)lispLcafAddress;
        ArrayList<Addresses> listAddresses = new ArrayList<Addresses>();
        for (int i = 0; i < lispListLCAFAddress.getAddresses().size(); ++i) {
            Addresses addresses = new AddressesBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress((LispAddress)lispListLCAFAddress.getAddresses().get(i))))).build();
            listAddresses.add(addresses);
        }
        return new LcafListBuilder().setAfi(Short.valueOf(lispLcafAddress.getAfi().getIanaCode())).setLcafType(Short.valueOf(lispLcafAddress.getType().getLispCode())).setAddresses(listAddresses).build();
    }

    public static LispAFIAddress transformLispSegmentLCAFAddress(LispLCAFAddress lispLcafAddress) {
        LispSegmentLCAFAddress lispSegmentLCAFAddress = (LispSegmentLCAFAddress)lispLcafAddress;
        org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsegmentaddress.Address address = new org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lcafsegmentaddress.AddressBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress(lispSegmentLCAFAddress.getAddress())))).build();
        return new LcafSegmentBuilder().setAfi(Short.valueOf(lispLcafAddress.getAfi().getIanaCode())).setLcafType(Short.valueOf(lispLcafAddress.getType().getLispCode())).setInstanceId(Long.valueOf(lispSegmentLCAFAddress.getInstanceId())).setAddress(address).build();
    }

    public static LispAFIAddress transformLispSourceDestLCAFAddress(LispLCAFAddress lispLcafAddress) {
        LispSourceDestLCAFAddress lispSourceDestLCAFAddress = (LispSourceDestLCAFAddress)lispLcafAddress;
        SrcAddress srcAddress = new SrcAddressBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress(lispSourceDestLCAFAddress.getSrcAddress())))).build();
        DstAddress dstAddress = new DstAddressBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress(lispSourceDestLCAFAddress.getDstAddress())))).build();
        return new LcafSourceDestBuilder().setAfi(Short.valueOf(lispLcafAddress.getAfi().getIanaCode())).setLcafType(Short.valueOf(lispLcafAddress.getType().getLispCode())).setSrcMaskLength(Short.valueOf(lispSourceDestLCAFAddress.getSrcMaskLength())).setDstMaskLength(Short.valueOf(lispSourceDestLCAFAddress.getDstMaskLength())).setSrcAddress(srcAddress).setDstAddress(dstAddress).build();
    }

    public static LispAFIAddress transformLispTrafficEngineeringLCAFAddress(LispLCAFAddress lispLcafAddress) {
        LispTrafficEngineeringLCAFAddress lispTrafficEngineeringLCAFAddress = (LispTrafficEngineeringLCAFAddress)lispLcafAddress;
        ArrayList<Hops> listHops = new ArrayList<Hops>();
        for (int i = 0; i < lispTrafficEngineeringLCAFAddress.getHops().size(); ++i) {
            org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop reencapHop = (org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop)lispTrafficEngineeringLCAFAddress.getHops().get(i);
            Hop hop = new HopBuilder().setPrimitiveAddress(YangTransformerNB.toPrimitive(YangTransformerNB.toAFI(YangTransformerNB.transformLispAddress(reencapHop.getHop())))).build();
            Hops hops = new HopsBuilder().setLookup(Boolean.valueOf(reencapHop.isLookup())).setRLOCProbe(Boolean.valueOf(reencapHop.isRLOCProbe())).setStrict(Boolean.valueOf(reencapHop.isStrict())).setHop(hop).build();
            listHops.add(hops);
        }
        return new LcafTrafficEngineeringBuilder().setAfi(Short.valueOf(lispLcafAddress.getAfi().getIanaCode())).setLcafType(Short.valueOf(lispLcafAddress.getType().getLispCode())).setHops(listHops).build();
    }

    public static LispAddress transformToLispAddress(LispAddressContainer lispAddress) {
        LispNoAddress legacyAddress = null;
        LispAFIAddress address = (LispAFIAddress)lispAddress.getAddress();
        AddressFamilyNumberEnum afi = AddressFamilyNumberEnum.valueOf((short)address.getAfi());
        block0 : switch (afi) {
            case IP: {
                org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv4Address lispIpv4Address = (org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv4Address)address;
                legacyAddress = new LispIpv4Address(lispIpv4Address.getIpv4Address().getValue());
                break;
            }
            case IP6: {
                org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv6Address lispIpv6Address = (org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv6Address)address;
                legacyAddress = new LispIpv6Address(lispIpv6Address.getIpv6Address().getValue());
                break;
            }
            case AS: {
                org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispASAddress lispASAddress = (org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispASAddress)address;
                legacyAddress = new LispASAddress(lispASAddress.getAS().intValue());
                break;
            }
            case DISTINGUISHED_NAME: {
                LispDistinguishedNameAddress lispDistinguishedNameAddress = (LispDistinguishedNameAddress)address;
                legacyAddress = new org.opendaylight.lispflowmapping.type.lisp.address.LispDistinguishedNameAddress(lispDistinguishedNameAddress.getDistinguishedName());
                break;
            }
            case MAC: {
                LispMacAddress lispMacAddress = (LispMacAddress)address;
                String macString = lispMacAddress.getMacAddress().getValue();
                macString = macString.replaceAll(":", "");
                legacyAddress = new LispMACAddress(DatatypeConverter.parseHexBinary((String)macString));
                break;
            }
            case NO_ADDRESS: {
                legacyAddress = new LispNoAddress();
                break;
            }
            case LCAF: {
                LispLcafAddress lispLcafAddress = (LispLcafAddress)address;
                LispCanonicalAddressFormatEnum lcafEnum = LispCanonicalAddressFormatEnum.valueOf((int)lispLcafAddress.getLcafType().shortValue());
                switch (lcafEnum) {
                    case APPLICATION_DATA: {
                        legacyAddress = YangTransformerNB.transformToLispApplicationDataLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case LIST: {
                        legacyAddress = YangTransformerNB.transformToLispListLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case SEGMENT: {
                        legacyAddress = YangTransformerNB.transformToLispSegmentLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case SOURCE_DEST: {
                        legacyAddress = YangTransformerNB.transformToLispSourceDestLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                    case TRAFFIC_ENGINEERING: {
                        legacyAddress = YangTransformerNB.transformToLispTrafficEngineeringLCAFAddress(lispLcafAddress);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("LCAF type " + lcafEnum + " not supported by this transoformer");
            }
            default: {
                throw new IllegalArgumentException("AFI " + afi + " not supported by this transformer");
            }
        }
        return legacyAddress;
    }

    public static LispAddress transformToLispApplicationDataLCAFAddress(LispLcafAddress lispLcafAddress) {
        LcafApplicationDataAddress lcafApplicationDataAddress = (LcafApplicationDataAddress)lispLcafAddress;
        return new LispApplicationDataLCAFAddress(0, lcafApplicationDataAddress.getProtocol().byteValue(), lcafApplicationDataAddress.getIpTos().intValue(), lcafApplicationDataAddress.getLocalPort().getValue().shortValue(), lcafApplicationDataAddress.getRemotePort().getValue().shortValue(), YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(lcafApplicationDataAddress.getAddress().getPrimitiveAddress()))));
    }

    public static LispAddress transformToLispListLCAFAddress(LispLcafAddress lispLcafAddress) {
        LcafListAddress lcafListAddress = (LcafListAddress)lispLcafAddress;
        ArrayList<LispAddress> listLegacyAddress = new ArrayList<LispAddress>();
        for (int i = 0; i < lcafListAddress.getAddresses().size(); ++i) {
            listLegacyAddress.add(YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(((Addresses)lcafListAddress.getAddresses().get(i)).getPrimitiveAddress()))));
        }
        return new LispListLCAFAddress(0, listLegacyAddress);
    }

    public static LispAddress transformToLispSegmentLCAFAddress(LispLcafAddress lispLcafAddress) {
        LcafSegmentAddress lcafSegmentAddress = (LcafSegmentAddress)lispLcafAddress;
        byte iidMaskLen = 0;
        return new LispSegmentLCAFAddress(iidMaskLen, lcafSegmentAddress.getInstanceId().intValue(), YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(lcafSegmentAddress.getAddress().getPrimitiveAddress()))));
    }

    public static LispAddress transformToLispSourceDestLCAFAddress(LispLcafAddress lispLcafAddress) {
        LcafSourceDestAddress lcafSourceDestAddress = (LcafSourceDestAddress)lispLcafAddress;
        return new LispSourceDestLCAFAddress(0, 0, lcafSourceDestAddress.getSrcMaskLength().byteValue(), lcafSourceDestAddress.getDstMaskLength().byteValue(), YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(lcafSourceDestAddress.getSrcAddress().getPrimitiveAddress()))), YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(lcafSourceDestAddress.getDstAddress().getPrimitiveAddress()))));
    }

    public static LispAddress transformToLispTrafficEngineeringLCAFAddress(LispLcafAddress lispLcafAddress) {
        LcafTrafficEngineeringAddress lcafTrafficEngineeringAddress = (LcafTrafficEngineeringAddress)lispLcafAddress;
        ArrayList<org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop> listLegacyHops = new ArrayList<org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop>();
        for (int i = 0; i < lcafTrafficEngineeringAddress.getHops().size(); ++i) {
            ReencapHop hop = (ReencapHop)lcafTrafficEngineeringAddress.getHops().get(i);
            org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop legacyHop = new org.opendaylight.lispflowmapping.type.lisp.address.ReencapHop(YangTransformerNB.transformToLispAddress(YangTransformerNB.toContainer(YangTransformerNB.toAFIfromPrimitive(hop.getHop().getPrimitiveAddress()))), 0, hop.isLookup().booleanValue(), hop.isRLOCProbe().booleanValue(), hop.isStrict().booleanValue());
            listLegacyHops.add(legacyHop);
        }
        return new LispTrafficEngineeringLCAFAddress(0, listLegacyHops);
    }

    public static MapRegister transformMapRegister(org.opendaylight.lispflowmapping.type.lisp.MapRegister legacyMapRegister) {
        ArrayList<EidToLocatorRecord> listEidToLocatorRecord = new ArrayList<EidToLocatorRecord>();
        for (int i = 0; i < legacyMapRegister.getEidToLocatorRecords().size(); ++i) {
            listEidToLocatorRecord.add(YangTransformerNB.transformEidToLocatorRecord((org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord)legacyMapRegister.getEidToLocatorRecords().get(i)));
        }
        MapRegisterBuilder builder = new MapRegisterBuilder();
        org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.mapregisternotification.MapRegister yangMapRegister = builder.setKeyId(Short.valueOf(legacyMapRegister.getKeyId())).setProxyMapReply(Boolean.valueOf(legacyMapRegister.isProxyMapReply())).setEidToLocatorRecord(listEidToLocatorRecord).setWantMapNotify(Boolean.valueOf(true)).build();
        return yangMapRegister;
    }

    public static EidToLocatorRecord transformEidToLocatorRecord(org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord legacyEidToLocatorRecord) {
        ArrayList<org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecord> listLocatorRecord = new ArrayList<org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecord>();
        for (int j = 0; j < legacyEidToLocatorRecord.getLocators().size(); ++j) {
            LocatorRecord legacyLocatorRecord = (LocatorRecord)legacyEidToLocatorRecord.getLocators().get(j);
            LispAddressContainer rloc = YangTransformerNB.transformLispAddress(legacyLocatorRecord.getLocator());
            LocatorRecordBuilder locatorRecordBuilder = new LocatorRecordBuilder();
            org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecord locatorRecord = locatorRecordBuilder.setLispAddressContainer(rloc).setLocalLocator(Boolean.valueOf(legacyLocatorRecord.isLocalLocator())).setPriority(Short.valueOf(legacyLocatorRecord.getPriority())).setWeight(Short.valueOf(legacyLocatorRecord.getWeight())).setMulticastPriority(Short.valueOf(legacyLocatorRecord.getMulticastPriority())).setMulticastWeight(Short.valueOf(legacyLocatorRecord.getMulticastWeight())).setRlocProbed(Boolean.valueOf(legacyLocatorRecord.isRlocProbed())).setRouted(Boolean.valueOf(legacyLocatorRecord.isRouted())).build();
            listLocatorRecord.add(locatorRecord);
        }
        LispAddressContainer eid = YangTransformerNB.transformLispAddress(legacyEidToLocatorRecord.getPrefix());
        EidToLocatorRecordBuilder eidToLocatorRecordBuilder = new EidToLocatorRecordBuilder();
        EidToLocatorRecord eidToLocatorRecord = eidToLocatorRecordBuilder.setLispAddressContainer(eid).setAction(EidToLocatorRecord.Action.forValue((int)legacyEidToLocatorRecord.getAction().getCode())).setAuthoritative(Boolean.valueOf(legacyEidToLocatorRecord.isAuthoritative())).setMaskLength(Short.valueOf((short)legacyEidToLocatorRecord.getMaskLength())).setRecordTtl(Integer.valueOf(legacyEidToLocatorRecord.getRecordTtl())).setLocatorRecord(listLocatorRecord).build();
        return eidToLocatorRecord;
    }

    public static org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord reTransformEidToLocatorRecord(EidToLocatorRecord eidToLocatorRecord) {
        org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord legacyRecord = new org.opendaylight.lispflowmapping.type.lisp.EidToLocatorRecord();
        for (int j = 0; j < eidToLocatorRecord.getLocatorRecord().size(); ++j) {
            org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecord locatorRecord = (org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.locatorrecords.LocatorRecord)eidToLocatorRecord.getLocatorRecord().get(j);
            LocatorRecord legacyLocatorRecord = new LocatorRecord();
            LispAddressContainer rloc = locatorRecord.getLispAddressContainer();
            legacyLocatorRecord.setLocator(YangTransformerNB.transformToLispAddress(rloc));
            legacyLocatorRecord.setLocalLocator(locatorRecord.isLocalLocator().booleanValue()).setPriority(locatorRecord.getPriority().byteValue()).setWeight(locatorRecord.getWeight().byteValue()).setMulticastPriority(locatorRecord.getMulticastPriority().byteValue()).setMulticastWeight(locatorRecord.getMulticastWeight().byteValue()).setRlocProbed(locatorRecord.isRlocProbed().booleanValue()).setRouted(locatorRecord.isRouted().booleanValue());
            legacyRecord.addLocator(legacyLocatorRecord);
        }
        LispAddress eid = YangTransformerNB.transformToLispAddress(eidToLocatorRecord.getLispAddressContainer());
        legacyRecord.setPrefix(eid).setAction(MapReplyAction.valueOf((int)eidToLocatorRecord.getAction().getIntValue())).setAuthoritative(eidToLocatorRecord.isAuthoritative().booleanValue()).setMaskLength((int)eidToLocatorRecord.getMaskLength().shortValue()).setRecordTtl(eidToLocatorRecord.getRecordTtl().intValue());
        return legacyRecord;
    }

    public static org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRequest transformMapRequest(MapRequest legacyMapRequest) {
        MapRequestBuilder builder = new MapRequestBuilder();
        builder.setAuthoritative(Boolean.valueOf(legacyMapRequest.isAuthoritative()));
        builder.setMapDataPresent(Boolean.valueOf(legacyMapRequest.isMapDataPresent()));
        builder.setPitr(Boolean.valueOf(legacyMapRequest.isPitr()));
        builder.setProbe(Boolean.valueOf(legacyMapRequest.isProbe()));
        builder.setSmr(Boolean.valueOf(legacyMapRequest.isSmr()));
        builder.setSmrInvoked(Boolean.valueOf(legacyMapRequest.isSmrInvoked()));
        builder.setEidRecord(new ArrayList());
        for (EidRecord record : legacyMapRequest.getEids()) {
            LispAddressContainer container = YangTransformerNB.transformLispAddress(record.getPrefix());
            builder.getEidRecord().add(new EidRecordBuilder().setMask(Short.valueOf((short)record.getMaskLength())).setLispAddressContainer(container).build());
        }
        builder.setItrRloc(new ArrayList());
        for (LispAddress itr : legacyMapRequest.getItrRlocs()) {
            builder.getItrRloc().add(new ItrRlocBuilder().setLispAddressContainer(YangTransformerNB.transformLispAddress(itr)).build());
        }
        builder.setMapReply(null);
        builder.setNonce(Long.valueOf(legacyMapRequest.getNonce()));
        if (legacyMapRequest.getSourceEid() != null) {
            builder.setSourceEid(new SourceEidBuilder().setLispAddressContainer(YangTransformerNB.transformLispAddress(legacyMapRequest.getSourceEid())).build());
        }
        return builder.build();
    }
}

