/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.southbound;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.sal.binding.api.AbstractBindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.lispflowmapping.implementation.serializer.MapNotifySerializer;
import org.opendaylight.lispflowmapping.implementation.serializer.MapReplySerializer;
import org.opendaylight.lispflowmapping.southbound.lisp.LispSouthboundService;
import org.opendaylight.lispflowmapping.type.sbplugin.IConfigLispPlugin;
import org.opendaylight.lispflowmapping.type.sbplugin.ILispSouthboundPlugin;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapNotify;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapReply;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispSouthboundPlugin
extends AbstractBindingAwareProvider
implements ILispSouthboundPlugin,
IConfigLispPlugin,
CommandProvider {
    protected static final Logger logger = LoggerFactory.getLogger(LispSouthboundPlugin.class);
    private static Object startLock = new Object();
    private LispIoThread thread;
    private LispSouthboundService lispSouthboundService;
    private volatile DatagramSocket socket = null;
    private final String MAP_NOTIFY = "MapNotify";
    private final String MAP_REPlY = "MapReply";
    private volatile String bindingAddress = null;
    private volatile boolean stillRunning = false;
    private volatile boolean alreadyInit = false;

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
        bundleContext.registerService(IConfigLispPlugin.class.getName(), (Object)this, null);
    }

    protected void stopImpl(BundleContext context) {
        this.unloadActions();
    }

    private void unloadActions() {
        if (this.thread != null) {
            this.thread.stopRunning();
        }
        this.lispSouthboundService = null;
        this.thread = null;
        logger.info("LISP (RFC6830) Mapping Service is down!");
        try {
            Thread.sleep(1100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void destroy() {
        this.unloadActions();
    }

    public static String intToIpv4(int address) {
        return (address >> 24 & 0xFF) + "." + (address >> 16 & 0xFF) + "." + (address >> 8 & 0xFF) + "." + (address >> 0 & 0xFF);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---LISP Southbound Plugin---\n");
        return help.toString();
    }

    private void startIOThread() {
        this.thread = new LispIoThread();
        logger.info("LISP (RFC6830) Mapping Service Southbound Plugin is up!");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        logger.info("LISP (RFC6830) Mapping Service is up!");
        Object object = startLock;
        synchronized (object) {
            if (!this.alreadyInit) {
                this.alreadyInit = true;
                this.lispSouthboundService = new LispSouthboundService();
                this.registerWithOSGIConsole();
                this.registerRPCs(session);
                logger.trace("Provider Session initialized");
                if (this.bindingAddress == null) {
                    this.setLispAddress("0.0.0.0");
                }
            }
        }
    }

    private void registerRPCs(BindingAwareBroker.ProviderContext session) {
        try {
            this.lispSouthboundService.setNotificationProvider((NotificationProviderService)session.getSALService(NotificationProviderService.class));
            session.addRpcImplementation(ILispSouthboundPlugin.class, (RpcService)this);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Future<RpcResult<Void>> handleMapNotify(MapNotify mapNotify, InetAddress address) {
        logger.trace("handleMapNotify called!!");
        if (mapNotify != null) {
            ByteBuffer outBuffer = MapNotifySerializer.getInstance().serialize(mapNotify);
            this.handleSerializedLispBuffer(address, outBuffer, "MapNotify");
        } else {
            logger.warn("MapNotify was null");
        }
        return null;
    }

    private void handleSerializedLispBuffer(InetAddress address, ByteBuffer outBuffer, String packetType) {
        DatagramPacket packet = new DatagramPacket(outBuffer.array(), outBuffer.limit());
        packet.setPort(4342);
        packet.setAddress(address);
        try {
            if (logger.isDebugEnabled()) {
                logger.trace("Sending " + packetType + " on port " + 4342 + " to address: " + address);
            }
            this.socket.send(packet);
        }
        catch (IOException e) {
            logger.warn("Failed to send " + packetType, (Throwable)e);
        }
    }

    public Future<RpcResult<Void>> handleMapReply(MapReply mapReply, InetAddress address) {
        logger.trace("handleMapReply called!!");
        if (mapReply != null) {
            ByteBuffer outBuffer = MapReplySerializer.getInstance().serialize(mapReply);
            this.handleSerializedLispBuffer(address, outBuffer, "MapReply");
        } else {
            logger.warn("MapReply was null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLispAddress(String address) {
        Object object = startLock;
        synchronized (object) {
            if (this.bindingAddress != null && this.bindingAddress.equals(address)) {
                logger.trace("configured lisp binding address didn't change.");
            } else {
                String action = this.bindingAddress == null ? "Setting" : "Resetting";
                logger.trace(action + " lisp binding address to: " + address);
                this.bindingAddress = address;
                if (this.thread != null) {
                    this.thread.stopRunning();
                    while (this.stillRunning) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                this.startIOThread();
            }
        }
    }

    private class LispIoThread
    extends Thread {
        private volatile boolean running;

        public LispIoThread() {
            super("Lisp Thread");
            this.running = true;
        }

        @Override
        public void run() {
            LispSouthboundPlugin.this.stillRunning = true;
            int lispPortNumber = 4342;
            int lispReceiveTimeout = 1000;
            logger.info("LISP (RFC6830) Mapping Service is running and listening on " + LispSouthboundPlugin.this.bindingAddress);
            try {
                LispSouthboundPlugin.this.socket = new DatagramSocket(new InetSocketAddress(LispSouthboundPlugin.this.bindingAddress, lispPortNumber));
                LispSouthboundPlugin.this.socket.setSoTimeout(lispReceiveTimeout);
            }
            catch (SocketException e) {
                logger.error("Cannot open socket on UDP port " + lispPortNumber, (Throwable)e);
                return;
            }
            while (this.running) {
                byte[] buffer = new byte[4096];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    LispSouthboundPlugin.this.socket.receive(packet);
                    logger.trace("Received a packet!");
                }
                catch (SocketTimeoutException ste) {
                    continue;
                }
                catch (IOException e) {
                    logger.warn("IO Exception while trying to recieve packet", (Throwable)e);
                }
                logger.trace(String.format("Handling packet from {%s}:{%d} (len={%d})", packet.getAddress().getHostAddress(), packet.getPort(), packet.getLength()));
                try {
                    LispSouthboundPlugin.this.lispSouthboundService.handlePacket(packet);
                }
                catch (Throwable t) {
                    logger.warn("Error while handling packet", t);
                }
            }
            LispSouthboundPlugin.this.socket.close();
            logger.trace("Socket closed");
            LispSouthboundPlugin.this.stillRunning = false;
        }

        public void stopRunning() {
            this.running = false;
        }
    }
}

