/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.southbound.lisp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.lispflowmapping.implementation.serializer.LispMessageEnum;
import org.opendaylight.lispflowmapping.implementation.serializer.MapRegisterSerializer;
import org.opendaylight.lispflowmapping.implementation.serializer.MapRequestSerializer;
import org.opendaylight.lispflowmapping.implementation.util.ByteUtil;
import org.opendaylight.lispflowmapping.implementation.util.LispNotificationHelper;
import org.opendaylight.lispflowmapping.southbound.lisp.ILispSouthboundService;
import org.opendaylight.lispflowmapping.southbound.lisp.exception.LispMalformedPacketException;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.AddMappingBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv4Address;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.LispIpv6Address;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRegister;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.MapRequest;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.RequestMappingBuilder;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.lispaddress.lispaddresscontainer.Address;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.maprequest.ItrRloc;
import org.opendaylight.yang.gen.v1.lispflowmapping.rev131031.transportaddress.TransportAddressBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispSouthboundService
implements ILispSouthboundService {
    private NotificationProviderService notificationProvider;
    protected static final Logger logger = LoggerFactory.getLogger(LispSouthboundService.class);

    public void setNotificationProvider(NotificationProviderService nps) {
        this.notificationProvider = nps;
    }

    @Override
    public void handlePacket(DatagramPacket packet) {
        ByteBuffer inBuffer = ByteBuffer.wrap(packet.getData(), 0, packet.getLength());
        LispMessageEnum lispType = LispMessageEnum.valueOf((byte)((byte)(ByteUtil.getUnsignedByte((ByteBuffer)inBuffer, (int)0) >> 4)));
        if (lispType == LispMessageEnum.EncapsulatedControlMessage) {
            logger.trace("Recieved packet of type EncapsulatedControlMessage");
            this.handleEncapsulatedControlMessage(inBuffer, packet.getAddress());
        } else if (lispType == LispMessageEnum.MapRequest) {
            logger.trace("Recieved packet of type MapRequest");
            this.handleMapRequest(inBuffer);
        } else if (lispType == LispMessageEnum.MapRegister) {
            logger.trace("Recieved packet of type MapRegister");
            this.handleMapRegister(inBuffer, packet.getAddress());
        }
        logger.warn("Recieved unknown packet type");
    }

    private void handleEncapsulatedControlMessage(ByteBuffer inBuffer, InetAddress sourceAddress) {
        try {
            this.extractEncapsulatedSourcePort(inBuffer);
            this.handleMapRequest(inBuffer);
        }
        catch (RuntimeException re) {
            throw new LispMalformedPacketException("Couldn't deserialize Map-Request (len=" + inBuffer.capacity() + ")", re);
        }
    }

    private void handleMapRequest(ByteBuffer inBuffer) {
        try {
            MapRequest request = MapRequestSerializer.getInstance().deserialize(inBuffer);
            InetAddress finalSourceAddress = null;
            for (ItrRloc itr : request.getItrRloc()) {
                Address addr = itr.getLispAddressContainer().getAddress();
                if (addr instanceof LispIpv4Address) {
                    try {
                        finalSourceAddress = InetAddress.getByName(((LispIpv4Address)addr).getIpv4Address().getValue());
                    }
                    catch (UnknownHostException e) {}
                    break;
                }
                if (!(addr instanceof LispIpv6Address)) continue;
                try {
                    finalSourceAddress = InetAddress.getByName(((LispIpv6Address)addr).getIpv6Address().getValue());
                }
                catch (UnknownHostException e) {}
                break;
            }
            if (finalSourceAddress == null) {
                throw new LispMalformedPacketException("Couldn't deserialize Map-Request, no ITR Rloc found!");
            }
            RequestMappingBuilder requestMappingBuilder = new RequestMappingBuilder();
            requestMappingBuilder.setMapRequest(LispNotificationHelper.convertMapRequest((MapRequest)request));
            TransportAddressBuilder transportAddressBuilder = new TransportAddressBuilder();
            transportAddressBuilder.setIpAddress(LispNotificationHelper.getIpAddressFromInetAddress((InetAddress)finalSourceAddress));
            requestMappingBuilder.setTransportAddress(transportAddressBuilder.build());
            if (this.notificationProvider != null) {
                this.notificationProvider.publish((Notification)requestMappingBuilder.build());
                logger.trace("MapRequest was published!");
            } else {
                logger.warn("Notification Provider is null!");
            }
        }
        catch (RuntimeException re) {
            throw new LispMalformedPacketException("Couldn't deserialize Map-Request (len=" + inBuffer.capacity() + ")", re);
        }
    }

    private int extractEncapsulatedSourcePort(ByteBuffer inBuffer) {
        try {
            inBuffer.position(4);
            int ipType = inBuffer.get() >> 4;
            if (ipType == 4) {
                inBuffer.position(inBuffer.position() + 20 - 1);
            } else {
                inBuffer.position(inBuffer.position() + 40 - 1);
            }
            int encapsulatedSourcePort = inBuffer.getShort() & 0xFFFF;
            inBuffer.position(inBuffer.position() + 8 - 2);
            return encapsulatedSourcePort;
        }
        catch (RuntimeException re) {
            throw new LispMalformedPacketException("Couldn't deserialize Map-Request (len=" + inBuffer.capacity() + ")", re);
        }
    }

    private void handleMapRegister(ByteBuffer inBuffer, InetAddress sourceAddress) {
        try {
            MapRegister mapRegister = MapRegisterSerializer.getInstance().deserialize(inBuffer);
            AddMappingBuilder addMappingBuilder = new AddMappingBuilder();
            addMappingBuilder.setMapRegister(LispNotificationHelper.convertMapRegister((MapRegister)mapRegister));
            TransportAddressBuilder transportAddressBuilder = new TransportAddressBuilder();
            transportAddressBuilder.setIpAddress(LispNotificationHelper.getIpAddressFromInetAddress((InetAddress)sourceAddress));
            addMappingBuilder.setTransportAddress(transportAddressBuilder.build());
            if (this.notificationProvider != null) {
                this.notificationProvider.publish((Notification)addMappingBuilder.build());
                logger.trace("MapRegister was published!");
            } else {
                logger.warn("Notification Provider is null!");
            }
        }
        catch (RuntimeException re) {
            throw new LispMalformedPacketException("Couldn't deserialize Map-Register (len=" + inBuffer.capacity() + ")", re);
        }
    }
}

